<?php
$form = $this->form;

// TODO: Better handle date and date time field. Restrict the days and ranges that are available for selection.
// TODO: handle images, see previous commit with field code.

// Check if the form was submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (isset($_POST['form_id']) && $_POST['form_id'] === strval($form->id)) {
    $formSubmissionResult = $this->handle_form_submission($form);
    if ($formSubmissionResult === true) {
      $showSuccessMessage = true;
    } else {
      $errorMessage = $formSubmissionResult;
    }
  }
}
?>

<div class="itin itinerator-form <?= isset($this->attributes['align']) ? 'align' . $this->attributes['align'] : ''; ?> <?= isset($this->attributes['className']) ? $this->attributes['className'] : ''; ?>">
  <div class="content">
    <?php if (isset($showSuccessMessage) && $showSuccessMessage) : ?>
      <div class="alert alert-success">
        Thank you for submitting the form!
      </div>
    <?php else : ?>
      <form method="POST" enctype="multipart/form-data">
        <?php if (isset($this->attributes['showName']) && $this->attributes['showName']) : ?>
          <div class="form-title">
            <h2><?= isset($form->name) ? $form->name : ''; ?></h2>
          </div>
        <?php endif; ?>
        <?php if (isset($this->attributes['showDescription']) && $this->attributes['showDescription']) : ?>
          <div class="form-description">
            <p><?= isset($form->description) ? $this->parse_markdown($form->description) : ''; ?></p>
          </div>
        <?php endif; ?>


        <?php if (isset($errorMessage)) : ?>
          <div class="alert alert-danger"><?= $errorMessage; ?></div>
        <?php endif; ?>
        <input name="form_id" type="hidden" value="<?= $form->id; ?>">
        <?php if (isset($form->form_fields) && is_array($form->form_fields)) : ?>
          <?php foreach ($form->form_fields as $field) : ?>
            <div class="form-group my-4">
              <label for="<?= $field->id; ?>">
                <?= $field->label; ?>
                <?php if ($field->required) : ?>
                  <span class="text-danger">*</span>
                <?php endif; ?>
              </label>
              <?php if (isset($field->description) && $field->description) : ?>
                <small class="form-text text-muted form-description"><?= $this->parse_markdown($field->description); ?></small>
              <?php endif; ?>


              <?php if ($field->type === 'TextField') : ?>
                <input type="text" class="form-control" id="<?= $field->id; ?>" name="<?= $field->id; ?>" <?= $field->required ? 'required' : ''; ?>>


              <?php elseif ($field->type === 'NumberField') : ?>
                <input type="number" class="form-control" id="<?= $field->id; ?>" name="<?= $field->id; ?>" min="<?= isset($field->options->min) ? $field->options->min : ''; ?>" max="<?= isset($field->options->max) ? $field->options->max : ''; ?>" <?= $field->required ? 'required' : ''; ?>>
                <?php if (isset($field->options->min) && isset($field->options->max) && $field->options->min !== null && $field->options->max !== null) : ?>
                  <small class="form-text text-muted form-value-min-max">The value must be between <?= $field->options->min; ?> and <?= $field->options->max; ?>.</small>
                <?php endif; ?>



              <?php elseif ($field->type === 'DateTimeField') : ?>
                <input type="datetime-local" class="form-control datetime-field" id="<?= $field->id; ?>" name="<?= $field->id; ?>" <?= $field->required ? 'required' : ''; ?> data-config='<?= json_encode(['startDate' => isset($field->options->start_date) ? $field->options->start_date : '', 'endDate' => isset($field->options->end_date) ? $field->options->end_date : '', 'allowedDays' => isset($field->options->allowed_days) ? $field->options->allowed_days : [],]); ?>'>
                <small class="form-text text-muted form-allowed-days">
                  Available dates: <?= isset($field->options->start_date) ? date('Y-m-d', strtotime($field->options->start_date)) : ''; ?> to <?= isset($field->options->end_date) ? date('Y-m-d', strtotime($field->options->end_date)) : ''; ?> (allowed days: <?= isset($field->options->allowed_days) ? implode(', ', $field->options->allowed_days) : ''; ?>)
                </small>




              <?php elseif ($field->type === 'DateField') : ?>
                <input type="date" class="form-control date-field" id="<?= $field->id; ?>" name="<?= $field->id; ?>" <?= $field->required ? 'required' : ''; ?> data-config='<?= json_encode(['startDate' => isset($field->options->start_date) ? $field->options->start_date : '', 'endDate' => isset($field->options->end_date) ? $field->options->end_date : '', 'allowedDays' => isset($field->options->allowed_days) ? $field->options->allowed_days : [],]); ?>'>
                <small class="form-text text-muted form-allowed-days">
                  Available dates: <?= isset($field->options->start_date) ? date('Y-m-d', strtotime($field->options->start_date)) : ''; ?> to <?= isset($field->options->end_date) ? date('Y-m-d', strtotime($field->options->end_date)) : ''; ?> (allowed days: <?= isset($field->options->allowed_days) ? implode(', ', $field->options->allowed_days) : ''; ?>)
                </small>




              <?php elseif ($field->type === 'SelectField') : ?>
                <?php if (isset($field->options->input_type) && $field->options->input_type === 'radio') : ?>
                  <?php foreach ($field->options->choices as $choice) : ?>
                    <div class="form-check">
                      <input class="form-check-input" type="radio" id="<?= $field->id . '_' . sanitize_title($choice); ?>" name="<?= $field->id; ?>" value="<?= $choice; ?>" <?= $field->required ? 'required' : ''; ?>>
                      <label class="form-check-label" for="<?= $field->id . '_' . sanitize_title($choice); ?>">
                        <?= $choice; ?>
                      </label>
                    </div>
                  <?php endforeach; ?>
                <?php else : ?>
                  <!-- Classic select field (not radio) -->
                  <select class="form-control" id="<?= $field->id; ?>" name="<?= $field->id; ?>" <?= $field->required ? 'required' : ''; ?>>
                    <option value="">Select an option</option>
                    <?php foreach ($field->options->choices as $choice) : ?>
                      <option value="<?= $choice; ?>"><?= $choice; ?></option>
                    <?php endforeach; ?>
                  </select>
                <?php endif; ?>



              <?php elseif ($field->type === 'MultiSelectField') : ?>
                <?php if (isset($field->options->input_type) && $field->options->input_type === 'checkbox') : ?>
                  <div class="form-group checkbox-group <?= $field->required ? 'required' : ''; ?>">
                    <?php foreach ($field->options->choices as $choice) : ?>
                      <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" id="<?= esc_attr($field->id . '_' . sanitize_title($choice)); ?>" name="<?= esc_attr($field->id); ?>[]" value="<?= esc_attr($choice); ?>" <?= $field->required ? 'required' : ''; ?> onclick='deRequire("<?= esc_attr($field->id); ?>[]")'>
                        <label class="form-check-label" for="<?= esc_attr($field->id . '_' . sanitize_title($choice)); ?>">
                          <?= esc_attr($choice); ?>
                        </label>
                      </div>
                    <?php endforeach; ?>
                  </div>
                  <script>
                    function deRequire(name) {
                      let elements = document.getElementsByName(name);
                      var someChecked = false;
                      elements.forEach(element => someChecked = someChecked || element.checked);
                      elements.forEach(element => element.required = !someChecked);
                    }
                  </script>
                <?php elseif (isset($field->options->input_type) && $field->options->input_type === 'select') : ?>
                  <div class="form-group my-4">
                    <select class="form-control" id="<?= esc_attr($field->id); ?>" name="<?= esc_attr($field->id); ?>[]" <?= $field->required ? 'required' : ''; ?> multiple>
                      <?php foreach ($field->options->choices as $choice) : ?>
                        <option value="<?= esc_attr($choice); ?>"><?= esc_html($choice); ?></option>
                      <?php endforeach; ?>
                      </>
                  </div>
                <?php endif; ?>








              <?php elseif ($field->type === 'ImageField') : ?>
                <div class="custom-file">
                  <input type="file" class="custom-file-input" id="<?= $field->id; ?>" name="<?= $field->id; ?>[]" <?= $field->required ? 'required' : ''; ?> <?= $field->options->multiple ? 'multiple' : ''; ?>>
                  <label class="custom-file-label" for="<?= $field->id; ?>">Choose file(s)</label>
                </div>
                <?php if (isset($field->options->min_count) && isset($field->options->max_count) && $field->options->min_count !== null && $field->options->max_count !== null) : ?>
                  <small class="form-text text-muted form-value-min-max">You must upload between <?= $field->options->min_count; ?> and <?= $field->options->max_count; ?>.</small>
                <?php endif; ?>




              <?php elseif ($field->type === 'BooleanField') : ?>
                <div class="form-check">
                  <input class="form-check-input" type="checkbox" id="<?= $field->id; ?>" name="<?= $field->id; ?>" <?= $field->required ? 'required' : ''; ?>>
                  <label class="form-check-label" for="<?= $field->id; ?>">
                    <?= $field->label; ?>
                  </label>
                </div>
              <?php endif; ?>


              <?php if (isset($field->helper_text) && $field->helper_text) : ?>
                <small class="form-text text-muted form-helper-text"><?= $field->helper_text; ?></small>
              <?php endif; ?>

            </div>
          <?php endforeach; ?>
        <?php endif; ?>

        <button type="submit" class="btn btn-primary">Submit</button>
      </form>
    <?php endif; ?>
  </div>
</div>
