<?php if (!empty($this->itineraries)) { ?>
	<div class="itin itinerator-itineraries alignwide">
		<?php foreach ($this->itineraries as $itinerary) : ?>
			<div class="itinerator-itinerary">
				<?php echo $itinerary->hero->getImg() ?>
				<h4>
					<?php echo $itinerary->name ?>
				</h4>
				<div>
					<span class="itinerator-itinerary-counts">
						<?php echo pluralize($itinerary->stop_count, "Stop", true) ?>
						|
						<?php echo pluralize($itinerary->leg_count, "Day", true) ?>
					</span>
					<span class="itinerator-itinerary-region-name">
						<?php echo $itinerary->region_name ?>
					</span>
				</div>
				<p>
					<?php echo $this->parse_markdown($itinerary->description) ?>
				</p>
				<div class="wp-block-buttons">
					<div class="wp-block-button">
						<a class="wp-block-button__link has-white-color has-accent-background-color has-text-color has-background itinerator-itinerary-button" href="<?php echo $itinerary->path ?>">
							Explore this itinerary
						</a>
					</div>
				</div>
			</div>
		<?php endforeach; ?>
	</div>

<?php } ?>
