<?php if (!empty($this->itineraries)) : ?>
  <div class="itin itinerator-itineraries <?= $this->attributes['align'] ? 'align' . $this->attributes['align'] : ''; ?> <?= $this->attributes['className'] ?? ''; ?>">
    <div class="container-fluid">
      <?php foreach ($this->itineraries as $itinerary) : ?>
        <div class="itineraries-row row justify-content-end align-items-center position-relative  mb-5 <?php echo $itinerary->filter_classes ?>" id="<?php echo $itinerary->slug ?>">
          <div class="col-12 col-md-6 order-md-2 p-0 open-half">
            <?php if (isset($itinerary->hero)) : ?>
              <div class="image itinerary-image-container">
                <a href="<?php echo $itinerary->path ?>" class="stretched-link"></a>
                <?php echo $itinerary->hero->getImg(null, "img-fluid itinerary-image"); ?>
              </div>
            <?php endif ?>

          </div>
          <div class="col-12 col-md-6 order-md-1 contained-half">
            <div class="content itinerary-content">
              <h4 class="card-title itinerary-name"><?php echo $itinerary->name ?></h4>
              <div class="d-flex flex-lg-row mb-3">
                <span class="itinerator-itinerary-counts mr-3">
                  <?php echo pluralize($itinerary->stop_count, "Stop", true) ?>
                  |
                  <?php echo pluralize($itinerary->leg_count, "Day", true) ?>
                </span>
                <span class="itinerator-itinerary-region-name">
                  <?php echo $itinerary->region_name ?>
                </span>
              </div>
              <div class="card-text itinerary-description"><?php echo $this->parse_markdown($itinerary->description) ?></div>
              <div class="d-grid gap-2">
                <a href="<?php echo $itinerary->path ?>" class="btn btn-primary itinerary-button">
                  <span><?php echo $this->attributes['buttonText'] ?></span> <?php echo $itinerary->name ?>
                </a>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
<?php endif ?>
