<div class="itin itinerator-itinerary <?= $this->attributes['align'] ? 'align' . $this->attributes['align'] : ''; ?> <?= $this->attributes['className'] ?? ''; ?>">
  <section class="section-itinerary anchor-point" id="trail">
    <div class="container-fluid">

      <ul class="nav nav-pills nav-justified d-md-none sticky-top py-4" role="tablist">
        <li class="nav-item d-none" role="presentation">
          <a class="nav-link active" id="itinerary-tab" data-toggle="pill" href="#itinerary" role="tab" aria-controls="itinerary" aria-selected="true">View Itinerary</a>
        </li>
        <li class="nav-item" role="presentation">
          <a class="nav-link" id="map-tab" data-toggle="pill" href="#map" role="tab" aria-controls="map" aria-selected="false">View Map</a>
        </li>
      </ul>

      <div class="tab-content row">
        <div class="tab-pane active d-md-block col-12 col-md-6" id="itinerary" role="tabpanel" aria-labelledby="itinerary-tab">
          <div class="row m-0">
            <div class="col-12 itinerary-content">
              <div class="group-start mt-3">
                <!-- Scrollama tag added here -->
                <div class="media">
                  <div class="media-body">
                    <h2 class="itineray-name"><?php echo $this->itinerary->name; ?></h2>
                    <div class="has-md-font-size"><?php echo $this->parse_markdown($this->itinerary->description); ?></div>
                  </div>
                </div>
              </div>
              <div>
                <?php /** Days (POI) start here */
                foreach ($this->itinerary->legs as $leg) {
                ?>
                  <div class="leg-title"><?= $leg->title ?></div>
                  <ul class="list-group list-group-flush">
                    <?php foreach ($leg->stops as $stop) {
                      $record_details = $stop->record_details;

                      //If Note
                      if (!isset($stop->target_type)) { ?>
                        <div class="media section">
                          <div class="media-body">
                            <?php if (isset($stop->hero)) { ?>
                              <img class="w-100 mb-3" src=<?php echo $stop->hero->getUrl('medium') ?> />
                            <?php } ?>
                            <?php echo $this->parse_markdown($stop->description); ?>
                          </div>
                        </div>
                      <?php }

                      //If Stop
                      if (!empty($record_details)) {
                      ?>
                        <li class="list-group-item" data-poi-index="<?php echo $stop->total_stop_number; ?>">
                          <div class="badge-col">
                            <div class="badge badge-pill"><?php echo $stop->total_stop_number; ?></div>
                          </div>
                          <div class="content">
                            <div class="h4">
                              <a class="title-link" href="<?php echo $record_details->path; ?>">
                                <?= $stop->name; ?>
                              </a>
                            </div>
                            <?php if ($stop->target_type === "Listing") : ?>
                              <div class="contact-details">
                                <?php if (!empty($record_details->full_address)) : ?>
                                  <div class="address"><?php echo $record_details->full_address; ?></div>
                                <?php endif; ?>
                                <?php if (!empty($record_details->website)) : ?>
                                  <a class="t-book-now-itinerary" href="<?= $record_details->website; ?>" target="_blank">
                                    <?= $record_details->website; ?>
                                  </a>
                                <?php endif; ?>
                              </div>
                            <?php endif; ?>
                            <div class="description"><?php echo $this->parse_markdown($stop->description); ?></div>

                          </div>
                        </li>
                    <?php
                      }
                    } ?>
                  </ul>
                <?php
                } ?>

              </div>
            </div>
          </div>
        </div>
        <div class="tab-pane d-md-block col-12 col-md-6" id="map" role="tabpanel" aria-labelledby="map-tab">
          <!-- <x-alert dated='yes' type='trails' /> -->
          <div class="map-container sticky-top">
            <div class="google-map">
              <div class="map-internals" style="display: none;">
                <?php
                //Reset for map
                foreach ($this->itinerary->legs as $leg) {
                  foreach ($leg->stops as $stop) {
                    $record_details = $stop->record_details;
                    if (!empty($record_details)) { ?>
                      <div class="marker" data-lat="<?php echo $record_details->lat; ?>" data-lng="<?php echo $record_details->lng; ?>" data-title="<?php echo $stop->name; ?>" data-poi-index="<?php echo $stop->total_stop_number; ?>" data-part="<?php echo $leg->order_on_itin; ?>">
                        <div data-marker>
                          <span class="badge map-badge badge-pill"><?php echo $stop->total_stop_number; ?></span>
                        </div>
                        <div data-infowindow>
                          <div class="media media-infowindow">
                            <div class="media-body">
                              <div class="title">
                                <a class="title-link" href="<?php echo $record_details->path; ?>">
                                  <?= $stop->name; ?>
                                </a>
                              </div>
                              <?php if ($stop->target_type === "Listing") : ?>
                                <div class="contact-details">
                                  <?php if (!empty($record_details->full_address)) : ?>
                                    <div class="address"><?php echo $record_details->full_address; ?></div>
                                  <?php endif; ?>
                                  <?php if (!empty($record_details->website)) : ?>
                                    <a class="t-book-now-itinerary" href="<?= $record_details->website; ?>" target="_blank">
                                      <?= $record_details->website; ?>
                                    </a>
                                  <?php endif; ?>
                                </div>
                              <?php endif; ?>
                            </div>
                          </div>
                        </div>
                  <?php
                    }
                  }
                }
                  ?>
                      </div>
              </div>
            </div>
          </div>
        </div>
      </div>
  </section>
</div>
