<?php if (count($this->listings) !== 0) { ?>
  <div class="itin itinerator-listings itinerator-premium-listings <?= $this->attributes['align'] ? 'align' . $this->attributes['align'] : ''; ?> <?= $this->attributes['className'] ?? ''; ?>">
    <div class="container-fluid">
      <div class="row g-4">
        <?php foreach ($this->listings as $listing) :  ?>
          <div class="col-12 col-md-4 mb-4 itinerator-listing <?php echo $listing->filter_classes ?>">
          <a href="<?php echo $listing->path ?>" class="stretched-link"></a>
            <div class="card h-100">
              <?php if ($this->showImage) : ?>
                <?php if (isset($listing->hero)) : ?>
                  <div class="card-img-top listing-image-container">
                    <img class="img-fluid rounded-top listing-image" src="<?php echo $listing->hero->getUrl('medium') ?>" alt="<?php echo $listing->hero->caption ?>">
                  </div>
                <?php else : ?>
                  <div class="card-img-top listing-image-container">
                    <div class="img-fluid rounded-top d-flex align-items-center justify-content-center listing-image listing-image-empty">
                      <span class="text-muted">No image available</span>
                    </div>
                  </div>
                <?php endif; ?>
              <?php endif; ?>
              <div class="card-body listing-content">
                <?php if ($this->showName) : ?><h4 class="card-title listing-name mb-0"><?php echo $listing->name ?></h4><?php endif; ?>
                <?php if ($this->showDescription) : ?><div class="card-text listing-description mt-3"><?php echo $this->parse_markdown($listing->short_description) ?></div><?php endif; ?>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
<?php } ?>
