<?php if (isset($event->event_times)) : ?>
  <?php
  $next_event = \Itinerator\Templates\Events::getNextEventTime($event->event_times);
  $is_series = \Itinerator\Templates\Events::isSeries($event);
  ?>
  <div class="event-datetimes fs-5 mb-2">
    <?php if ($next_event) : ?>
      <?php if ($datetimes = \Itinerator\Templates\Events::convertDateTimeRange($next_event->next_start, $next_event->next_end)) : ?>
        <div class="event-datetime">
          <div class="event-date-range">
            <strong>Date: </strong><?= $datetimes['date_range']; ?>
            <?php if ($is_series) : ?>
              <?php
              $occurrences = \Itinerator\Templates\Events::getRecurringEventOccurrences($event->event_times, 5);
              $tooltip_content = "Upcoming: ";
              foreach ($occurrences as $occurrence) {
                $tooltip_content .= $occurrence['start'] . ", ";
              }
              ?>

              <i class="qtip tip-bottom">
                <span class="fa fa-calendar mx-3"></span>
                <span class="tooltip-content"><?= $tooltip_content ?></span>
              </i>

            <?php endif; ?>
          </div>

          <div class="event-time-range">
            <strong>Time: </strong><?= !$next_event->all_day ? $datetimes['time_range'] : 'All Day'; ?>
          </div>
        </div>
      <?php endif; ?>
    <?php endif; ?>
  </div>
<?php endif; ?>
