<?php


class MPM_SharedFieldSet extends MPM_FieldSet {

  public function is_shared() {
    return true;
  }

  public static function table( $model = "field-sets" ) {
    return MPM::table( $model );
  }
  
  public function infer_position() {
  
    /*
    we need to find the appropriate starting sub position for this field set, assuming it comes AFTER other field sets 
    */
  
    global $wpdb;
    $max_pos = $wpdb->get_var("SELECT MAX(`position`) FROM `".MPM::table("field-sets")."` WHERE `type` = 's'");

    if ($max_pos) {
      $this->position = (int) $max_pos + 1;
    } else {
      $this->position = 1;
    }
  
  }

  public function construct_type() {
    return "s";
  }  
  

  public static function find_by_name($name) {
    return self::find( array( "where" => "`name` = '{$name}' AND `type` = 's'" ) ); 
  }



  public function validate_name($op) {
    if ($this->name != "") {
      // check there isn't already a field set with this name 
      
      $extra_check = "";
      
      if ($op != "insert") {
        $extra_check = " AND id <> ".$this->id." ";
      }
      
      $result = self::find( array("where" => "`type` = 's' AND `name` = '{$this->name}'". $extra_check ) );

      if ($result) {
        $this->err(sprintf(__("Sorry, a shared field set named <em>%s</em> already exists", MASTERPRESS_DOMAIN), $this->name), "name");
      }

    }
  }
    
  
  public function tbl() {
    return MPU::table("field_sets");
  } 


  public static function find($args = array(), $model = "field-set", $table = null) {
    $defaults = array(
      "where" => "`type` = 's'"
    );
    
    $r = wp_parse_args($args, $defaults);
    
    return parent::find($r);  
  }


}

?>