(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?module.exports=factory():typeof define==="function"&&define.amd?define(factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,global.BPBMMuuri=factory())})(this,function(){"use strict";var GRID_INSTANCES={};var ITEM_ELEMENT_MAP=typeof Map==="function"?new Map:null;var ACTION_SWAP="swap";var ACTION_MOVE="move";var EVENT_SYNCHRONIZE="synchronize";var EVENT_LAYOUT_START="layoutStart";var EVENT_LAYOUT_END="layoutEnd";var EVENT_LAYOUT_ABORT="layoutAbort";var EVENT_ADD="add";var EVENT_REMOVE="remove";var EVENT_SHOW_START="showStart";var EVENT_SHOW_END="showEnd";var EVENT_HIDE_START="hideStart";var EVENT_HIDE_END="hideEnd";var EVENT_FILTER="filter";var EVENT_SORT="sort";var EVENT_MOVE="move";var EVENT_SEND="send";var EVENT_BEFORE_SEND="beforeSend";var EVENT_RECEIVE="receive";var EVENT_BEFORE_RECEIVE="beforeReceive";var EVENT_DRAG_INIT="dragInit";var EVENT_DRAG_START="dragStart";var EVENT_DRAG_MOVE="dragMove";var EVENT_DRAG_SCROLL="dragScroll";var EVENT_DRAG_END="dragEnd";var EVENT_DRAG_RELEASE_START="dragReleaseStart";var EVENT_DRAG_RELEASE_END="dragReleaseEnd";var EVENT_DESTROY="destroy";var HAS_TOUCH_EVENTS="ontouchstart"in window;var HAS_POINTER_EVENTS=!!window.PointerEvent;var HAS_MS_POINTER_EVENTS=!!window.navigator.msPointerEnabled;var MAX_SAFE_FLOAT32_INTEGER=16777216;function Emitter(){this._events={};this._queue=[];this._counter=0;this._clearOnEmit=false}Emitter.prototype.on=function(event,listener){if(!this._events||!event||!listener)return this;var listeners=this._events[event];if(!listeners)listeners=this._events[event]=[];listeners.push(listener);return this};Emitter.prototype.off=function(event,listener){if(!this._events||!event||!listener)return this;var listeners=this._events[event];if(!listeners||!listeners.length)return this;var index;while((index=listeners.indexOf(listener))!==-1){listeners.splice(index,1)}return this};Emitter.prototype.clear=function(event){if(!this._events||!event)return this;var listeners=this._events[event];if(listeners){listeners.length=0;delete this._events[event]}return this};Emitter.prototype.emit=function(event){if(!this._events||!event){this._clearOnEmit=false;return this}var listeners=this._events[event];if(!listeners||!listeners.length){this._clearOnEmit=false;return this}var queue=this._queue;var startIndex=queue.length;var argsLength=arguments.length-1;var args;if(argsLength>3){args=[];args.push.apply(args,arguments);args.shift()}queue.push.apply(queue,listeners);if(this._clearOnEmit){listeners.length=0;this._clearOnEmit=false}++this._counter;var i=startIndex;var endIndex=queue.length;for(;i<endIndex;i++){argsLength===0?queue[i]():argsLength===1?queue[i](arguments[1]):argsLength===2?queue[i](arguments[1],arguments[2]):argsLength===3?queue[i](arguments[1],arguments[2],arguments[3]):queue[i].apply(null,args);if(!this._events)return this}--this._counter;if(!this._counter)queue.length=0;return this};Emitter.prototype.burst=function(){if(!this._events)return this;this._clearOnEmit=true;this.emit.apply(this,arguments);return this};Emitter.prototype.countListeners=function(event){if(!this._events)return 0;var listeners=this._events[event];return listeners?listeners.length:0};Emitter.prototype.destroy=function(){if(!this._events)return this;this._queue.length=this._counter=0;this._events=null;return this};var pointerout=HAS_POINTER_EVENTS?"pointerout":HAS_MS_POINTER_EVENTS?"MSPointerOut":"";var waitDuration=100;function EdgeHack(dragger){if(!pointerout)return;this._dragger=dragger;this._timeout=null;this._outEvent=null;this._isActive=false;this._addBehaviour=this._addBehaviour.bind(this);this._removeBehaviour=this._removeBehaviour.bind(this);this._onTimeout=this._onTimeout.bind(this);this._resetData=this._resetData.bind(this);this._onStart=this._onStart.bind(this);this._onOut=this._onOut.bind(this);this._dragger.on("start",this._onStart)}EdgeHack.prototype._addBehaviour=function(){if(this._isActive)return;this._isActive=true;this._dragger.on("move",this._resetData);this._dragger.on("cancel",this._removeBehaviour);this._dragger.on("end",this._removeBehaviour);window.addEventListener(pointerout,this._onOut)};EdgeHack.prototype._removeBehaviour=function(){if(!this._isActive)return;this._dragger.off("move",this._resetData);this._dragger.off("cancel",this._removeBehaviour);this._dragger.off("end",this._removeBehaviour);window.removeEventListener(pointerout,this._onOut);this._resetData();this._isActive=false};EdgeHack.prototype._resetData=function(){window.clearTimeout(this._timeout);this._timeout=null;this._outEvent=null};EdgeHack.prototype._onStart=function(e){if(e.pointerType==="mouse")return;this._addBehaviour()};EdgeHack.prototype._onOut=function(e){if(!this._dragger._getTrackedTouch(e))return;this._resetData();this._outEvent=e;this._timeout=window.setTimeout(this._onTimeout,waitDuration)};EdgeHack.prototype._onTimeout=function(){var e=this._outEvent;this._resetData();if(this._dragger.isActive())this._dragger._onCancel(e)};EdgeHack.prototype.destroy=function(){if(!pointerout)return;this._dragger.off("start",this._onStart);this._removeBehaviour()};var vendorPrefixes=["","webkit","moz","ms","o","Webkit","Moz","MS","O"];var cache$2={};function getPrefixedPropName(style,prop){var prefixedProp=cache$2[prop]||"";if(prefixedProp)return prefixedProp;var camelProp=prop[0].toUpperCase()+prop.slice(1);var i=0;while(i<vendorPrefixes.length){prefixedProp=vendorPrefixes[i]?vendorPrefixes[i]+camelProp:prop;if(prefixedProp in style){cache$2[prop]=prefixedProp;return prefixedProp}++i}return""}function hasPassiveEvents(){var isPassiveEventsSupported=false;try{var passiveOpts=Object.defineProperty({},"passive",{get:function(){isPassiveEventsSupported=true}});window.addEventListener("testPassive",null,passiveOpts);window.removeEventListener("testPassive",null,passiveOpts)}catch(e){}return isPassiveEventsSupported}var ua=window.navigator.userAgent.toLowerCase();var isEdge=ua.indexOf("edge")>-1;var isIE=ua.indexOf("trident")>-1;var isFirefox=ua.indexOf("firefox")>-1;var isAndroid=ua.indexOf("android")>-1;var listenerOptions=hasPassiveEvents()?{passive:true}:false;var taProp="touchAction";var taPropPrefixed=getPrefixedPropName(document.documentElement.style,taProp);var taDefaultValue="auto";function Dragger(element,cssProps){this._element=element;this._emitter=new Emitter;this._isDestroyed=false;this._cssProps={};this._touchAction="";this._isActive=false;this._pointerId=null;this._startTime=0;this._startX=0;this._startY=0;this._currentX=0;this._currentY=0;this._onStart=this._onStart.bind(this);this._onMove=this._onMove.bind(this);this._onCancel=this._onCancel.bind(this);this._onEnd=this._onEnd.bind(this);this._edgeHack=null;if((isEdge||isIE)&&(HAS_POINTER_EVENTS||HAS_MS_POINTER_EVENTS)){this._edgeHack=new EdgeHack(this)}this.setCssProps(cssProps);if(!this._touchAction){this.setTouchAction(taDefaultValue)}element.addEventListener("dragstart",Dragger._preventDefault,false);element.addEventListener(Dragger._inputEvents.start,this._onStart,listenerOptions)}Dragger._pointerEvents={start:"pointerdown",move:"pointermove",cancel:"pointercancel",end:"pointerup"};Dragger._msPointerEvents={start:"MSPointerDown",move:"MSPointerMove",cancel:"MSPointerCancel",end:"MSPointerUp"};Dragger._touchEvents={start:"touchstart",move:"touchmove",cancel:"touchcancel",end:"touchend"};Dragger._mouseEvents={start:"mousedown",move:"mousemove",cancel:"",end:"mouseup"};Dragger._inputEvents=function(){if(HAS_TOUCH_EVENTS)return Dragger._touchEvents;if(HAS_POINTER_EVENTS)return Dragger._pointerEvents;if(HAS_MS_POINTER_EVENTS)return Dragger._msPointerEvents;return Dragger._mouseEvents}();Dragger._emitter=new Emitter;Dragger._emitterEvents={start:"start",move:"move",end:"end",cancel:"cancel"};Dragger._activeInstances=[];Dragger._preventDefault=function(e){if(e.preventDefault&&e.cancelable!==false)e.preventDefault()};Dragger._activateInstance=function(instance){var index=Dragger._activeInstances.indexOf(instance);if(index>-1)return;Dragger._activeInstances.push(instance);Dragger._emitter.on(Dragger._emitterEvents.move,instance._onMove);Dragger._emitter.on(Dragger._emitterEvents.cancel,instance._onCancel);Dragger._emitter.on(Dragger._emitterEvents.end,instance._onEnd);if(Dragger._activeInstances.length===1){Dragger._bindListeners()}};Dragger._deactivateInstance=function(instance){var index=Dragger._activeInstances.indexOf(instance);if(index===-1)return;Dragger._activeInstances.splice(index,1);Dragger._emitter.off(Dragger._emitterEvents.move,instance._onMove);Dragger._emitter.off(Dragger._emitterEvents.cancel,instance._onCancel);Dragger._emitter.off(Dragger._emitterEvents.end,instance._onEnd);if(!Dragger._activeInstances.length){Dragger._unbindListeners()}};Dragger._bindListeners=function(){window.addEventListener(Dragger._inputEvents.move,Dragger._onMove,listenerOptions);window.addEventListener(Dragger._inputEvents.end,Dragger._onEnd,listenerOptions);if(Dragger._inputEvents.cancel){window.addEventListener(Dragger._inputEvents.cancel,Dragger._onCancel,listenerOptions)}};Dragger._unbindListeners=function(){window.removeEventListener(Dragger._inputEvents.move,Dragger._onMove,listenerOptions);window.removeEventListener(Dragger._inputEvents.end,Dragger._onEnd,listenerOptions);if(Dragger._inputEvents.cancel){window.removeEventListener(Dragger._inputEvents.cancel,Dragger._onCancel,listenerOptions)}};Dragger._getEventPointerId=function(event){if(typeof event.pointerId==="number"){return event.pointerId}if(event.changedTouches){return event.changedTouches[0]?event.changedTouches[0].identifier:null}return 1};Dragger._getTouchById=function(event,id){if(typeof event.pointerId==="number"){return event.pointerId===id?event:null}if(event.changedTouches){for(var i=0;i<event.changedTouches.length;i++){if(event.changedTouches[i].identifier===id){return event.changedTouches[i]}}return null}return event};Dragger._onMove=function(e){Dragger._emitter.emit(Dragger._emitterEvents.move,e)};Dragger._onCancel=function(e){Dragger._emitter.emit(Dragger._emitterEvents.cancel,e)};Dragger._onEnd=function(e){Dragger._emitter.emit(Dragger._emitterEvents.end,e)};Dragger.prototype._reset=function(){this._pointerId=null;this._startTime=0;this._startX=0;this._startY=0;this._currentX=0;this._currentY=0;this._isActive=false;Dragger._deactivateInstance(this)};Dragger.prototype._createEvent=function(type,e){var touch=this._getTrackedTouch(e);return{type:type,srcEvent:e,distance:this.getDistance(),deltaX:this.getDeltaX(),deltaY:this.getDeltaY(),deltaTime:type===Dragger._emitterEvents.start?0:this.getDeltaTime(),isFirst:type===Dragger._emitterEvents.start,isFinal:type===Dragger._emitterEvents.end||type===Dragger._emitterEvents.cancel,pointerType:e.pointerType||(e.touches?"touch":"mouse"),identifier:this._pointerId,screenX:touch.screenX,screenY:touch.screenY,clientX:touch.clientX,clientY:touch.clientY,pageX:touch.pageX,pageY:touch.pageY,target:touch.target}};Dragger.prototype._emit=function(type,e){this._emitter.emit(type,this._createEvent(type,e))};Dragger.prototype._getTrackedTouch=function(e){if(this._pointerId===null)return null;return Dragger._getTouchById(e,this._pointerId)};Dragger.prototype._onStart=function(e){if(this._isDestroyed)return;if(this._pointerId!==null)return;this._pointerId=Dragger._getEventPointerId(e);if(this._pointerId===null)return;var touch=this._getTrackedTouch(e);this._startX=this._currentX=touch.clientX;this._startY=this._currentY=touch.clientY;this._startTime=Date.now();this._isActive=true;this._emit(Dragger._emitterEvents.start,e);if(this._isActive){Dragger._activateInstance(this)}};Dragger.prototype._onMove=function(e){var touch=this._getTrackedTouch(e);if(!touch)return;this._currentX=touch.clientX;this._currentY=touch.clientY;this._emit(Dragger._emitterEvents.move,e)};Dragger.prototype._onCancel=function(e){if(!this._getTrackedTouch(e))return;this._emit(Dragger._emitterEvents.cancel,e);this._reset()};Dragger.prototype._onEnd=function(e){if(!this._getTrackedTouch(e))return;this._emit(Dragger._emitterEvents.end,e);this._reset()};Dragger.prototype.isActive=function(){return this._isActive};Dragger.prototype.setTouchAction=function(value){this._touchAction=value;if(taPropPrefixed){this._cssProps[taPropPrefixed]="";this._element.style[taPropPrefixed]=value}if(HAS_TOUCH_EVENTS){this._element.removeEventListener(Dragger._touchEvents.start,Dragger._preventDefault,true);if(this._element.style[taPropPrefixed]!==value||isFirefox&&isAndroid){this._element.addEventListener(Dragger._touchEvents.start,Dragger._preventDefault,true)}}};Dragger.prototype.setCssProps=function(newProps){if(!newProps)return;var currentProps=this._cssProps;var element=this._element;var prop;var prefixedProp;for(prop in currentProps){element.style[prop]=currentProps[prop];delete currentProps[prop]}for(prop in newProps){if(!newProps[prop])continue;if(prop===taProp){this.setTouchAction(newProps[prop]);continue}prefixedProp=getPrefixedPropName(element.style,prop);if(!prefixedProp)continue;currentProps[prefixedProp]="";element.style[prefixedProp]=newProps[prop]}};Dragger.prototype.getDeltaX=function(){return this._currentX-this._startX};Dragger.prototype.getDeltaY=function(){return this._currentY-this._startY};Dragger.prototype.getDistance=function(){var x=this.getDeltaX();var y=this.getDeltaY();return Math.sqrt(x*x+y*y)};Dragger.prototype.getDeltaTime=function(){return this._startTime?Date.now()-this._startTime:0};Dragger.prototype.on=function(eventName,listener){this._emitter.on(eventName,listener)};Dragger.prototype.off=function(eventName,listener){this._emitter.off(eventName,listener)};Dragger.prototype.destroy=function(){if(this._isDestroyed)return;var element=this._element;if(this._edgeHack)this._edgeHack.destroy();this._reset();this._emitter.destroy();element.removeEventListener(Dragger._inputEvents.start,this._onStart,listenerOptions);element.removeEventListener("dragstart",Dragger._preventDefault,false);element.removeEventListener(Dragger._touchEvents.start,Dragger._preventDefault,true);for(var prop in this._cssProps){element.style[prop]=this._cssProps[prop];delete this._cssProps[prop]}this._element=null;this._isDestroyed=true};var dt=1e3/60;var raf=(window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.msRequestAnimationFrame||function(callback){return this.setTimeout(function(){callback(Date.now())},dt)}).bind(window);function Ticker(numLanes){this._nextStep=null;this._lanes=[];this._stepQueue=[];this._stepCallbacks={};this._step=this._step.bind(this);for(var i=0;i<numLanes;i++){this._lanes.push(new TickerLane)}}Ticker.prototype._step=function(time){var lanes=this._lanes;var stepQueue=this._stepQueue;var stepCallbacks=this._stepCallbacks;var i,j,id,laneQueue,laneCallbacks,laneIndices;this._nextStep=null;for(i=0;i<lanes.length;i++){laneQueue=lanes[i].queue;laneCallbacks=lanes[i].callbacks;laneIndices=lanes[i].indices;for(j=0;j<laneQueue.length;j++){id=laneQueue[j];if(!id)continue;stepQueue.push(id);stepCallbacks[id]=laneCallbacks[id];delete laneCallbacks[id];delete laneIndices[id]}laneQueue.length=0}for(i=0;i<stepQueue.length;i++){id=stepQueue[i];if(stepCallbacks[id])stepCallbacks[id](time);delete stepCallbacks[id]}stepQueue.length=0};Ticker.prototype.add=function(laneIndex,id,callback){this._lanes[laneIndex].add(id,callback);if(!this._nextStep)this._nextStep=raf(this._step)};Ticker.prototype.remove=function(laneIndex,id){this._lanes[laneIndex].remove(id)};function TickerLane(){this.queue=[];this.indices={};this.callbacks={}}TickerLane.prototype.add=function(id,callback){var index=this.indices[id];if(index!==undefined)this.queue[index]=undefined;this.queue.push(id);this.callbacks[id]=callback;this.indices[id]=this.queue.length-1};TickerLane.prototype.remove=function(id){var index=this.indices[id];if(index===undefined)return;this.queue[index]=undefined;delete this.callbacks[id];delete this.indices[id]};var LAYOUT_READ="layoutRead";var LAYOUT_WRITE="layoutWrite";var VISIBILITY_READ="visibilityRead";var VISIBILITY_WRITE="visibilityWrite";var DRAG_START_READ="dragStartRead";var DRAG_START_WRITE="dragStartWrite";var DRAG_MOVE_READ="dragMoveRead";var DRAG_MOVE_WRITE="dragMoveWrite";var DRAG_SCROLL_READ="dragScrollRead";var DRAG_SCROLL_WRITE="dragScrollWrite";var DRAG_SORT_READ="dragSortRead";var PLACEHOLDER_LAYOUT_READ="placeholderLayoutRead";var PLACEHOLDER_LAYOUT_WRITE="placeholderLayoutWrite";var PLACEHOLDER_RESIZE_WRITE="placeholderResizeWrite";var AUTO_SCROLL_READ="autoScrollRead";var AUTO_SCROLL_WRITE="autoScrollWrite";var DEBOUNCE_READ="debounceRead";var LANE_READ=0;var LANE_READ_TAIL=1;var LANE_WRITE=2;var ticker=new Ticker(3);function addLayoutTick(itemId,read,write){ticker.add(LANE_READ,LAYOUT_READ+itemId,read);ticker.add(LANE_WRITE,LAYOUT_WRITE+itemId,write)}function cancelLayoutTick(itemId){ticker.remove(LANE_READ,LAYOUT_READ+itemId);ticker.remove(LANE_WRITE,LAYOUT_WRITE+itemId)}function addVisibilityTick(itemId,read,write){ticker.add(LANE_READ,VISIBILITY_READ+itemId,read);ticker.add(LANE_WRITE,VISIBILITY_WRITE+itemId,write)}function cancelVisibilityTick(itemId){ticker.remove(LANE_READ,VISIBILITY_READ+itemId);ticker.remove(LANE_WRITE,VISIBILITY_WRITE+itemId)}function addDragStartTick(itemId,read,write){ticker.add(LANE_READ,DRAG_START_READ+itemId,read);ticker.add(LANE_WRITE,DRAG_START_WRITE+itemId,write)}function cancelDragStartTick(itemId){ticker.remove(LANE_READ,DRAG_START_READ+itemId);ticker.remove(LANE_WRITE,DRAG_START_WRITE+itemId)}function addDragMoveTick(itemId,read,write){ticker.add(LANE_READ,DRAG_MOVE_READ+itemId,read);ticker.add(LANE_WRITE,DRAG_MOVE_WRITE+itemId,write)}function cancelDragMoveTick(itemId){ticker.remove(LANE_READ,DRAG_MOVE_READ+itemId);ticker.remove(LANE_WRITE,DRAG_MOVE_WRITE+itemId)}function addDragScrollTick(itemId,read,write){ticker.add(LANE_READ,DRAG_SCROLL_READ+itemId,read);ticker.add(LANE_WRITE,DRAG_SCROLL_WRITE+itemId,write)}function cancelDragScrollTick(itemId){ticker.remove(LANE_READ,DRAG_SCROLL_READ+itemId);ticker.remove(LANE_WRITE,DRAG_SCROLL_WRITE+itemId)}function addDragSortTick(itemId,read){ticker.add(LANE_READ_TAIL,DRAG_SORT_READ+itemId,read)}function cancelDragSortTick(itemId){ticker.remove(LANE_READ_TAIL,DRAG_SORT_READ+itemId)}function addPlaceholderLayoutTick(itemId,read,write){ticker.add(LANE_READ,PLACEHOLDER_LAYOUT_READ+itemId,read);ticker.add(LANE_WRITE,PLACEHOLDER_LAYOUT_WRITE+itemId,write)}function cancelPlaceholderLayoutTick(itemId){ticker.remove(LANE_READ,PLACEHOLDER_LAYOUT_READ+itemId);ticker.remove(LANE_WRITE,PLACEHOLDER_LAYOUT_WRITE+itemId)}function addPlaceholderResizeTick(itemId,write){ticker.add(LANE_WRITE,PLACEHOLDER_RESIZE_WRITE+itemId,write)}function cancelPlaceholderResizeTick(itemId){ticker.remove(LANE_WRITE,PLACEHOLDER_RESIZE_WRITE+itemId)}function addAutoScrollTick(read,write){ticker.add(LANE_READ,AUTO_SCROLL_READ,read);ticker.add(LANE_WRITE,AUTO_SCROLL_WRITE,write)}function cancelAutoScrollTick(){ticker.remove(LANE_READ,AUTO_SCROLL_READ);ticker.remove(LANE_WRITE,AUTO_SCROLL_WRITE)}function addDebounceTick(debounceId,read){ticker.add(LANE_READ,DEBOUNCE_READ+debounceId,read)}function cancelDebounceTick(debounceId){ticker.remove(LANE_READ,DEBOUNCE_READ+debounceId)}var AXIS_X=1;var AXIS_Y=2;var FORWARD=4;var BACKWARD=8;var LEFT=AXIS_X|BACKWARD;var RIGHT=AXIS_X|FORWARD;var UP=AXIS_Y|BACKWARD;var DOWN=AXIS_Y|FORWARD;var functionType="function";function isFunction(val){return typeof val===functionType}var cache$1=typeof WeakMap==="function"?new WeakMap:null;function getStyle(element,style){var styles=cache$1&&cache$1.get(element);if(!styles){styles=window.getComputedStyle(element,null);if(cache$1)cache$1.set(element,styles)}return styles.getPropertyValue(style)}function getStyleAsFloat(el,style){return parseFloat(getStyle(el,style))||0}var DOC_ELEM=document.documentElement;var BODY=document.body;var THRESHOLD_DATA={value:0,offset:0};function getScrollElement(element){if(element===window||element===DOC_ELEM||element===BODY){return window}else{return element}}function getScrollLeft(element){return element===window?element.pageXOffset:element.scrollLeft}function getScrollTop(element){return element===window?element.pageYOffset:element.scrollTop}function getScrollLeftMax(element){if(element===window){return DOC_ELEM.scrollWidth-DOC_ELEM.clientWidth}else{return element.scrollWidth-element.clientWidth}}function getScrollTopMax(element){if(element===window){return DOC_ELEM.scrollHeight-DOC_ELEM.clientHeight}else{return element.scrollHeight-element.clientHeight}}function getContentRect(element,result){result=result||{};if(element===window){result.width=DOC_ELEM.clientWidth;result.height=DOC_ELEM.clientHeight;result.left=0;result.right=result.width;result.top=0;result.bottom=result.height}else{var bcr=element.getBoundingClientRect();var borderLeft=element.clientLeft||getStyleAsFloat(element,"border-left-width");var borderTop=element.clientTop||getStyleAsFloat(element,"border-top-width");result.width=element.clientWidth;result.height=element.clientHeight;result.left=bcr.left+borderLeft;result.right=result.left+result.width;result.top=bcr.top+borderTop;result.bottom=result.top+result.height}return result}function getItemAutoScrollSettings(item){return item._drag._getGrid()._settings.dragAutoScroll}function prepareItemScrollSync(item){if(!item._drag)return;item._drag._prepareScroll()}function applyItemScrollSync(item){if(!item._drag||!item._isActive)return;var drag=item._drag;drag._scrollDiffX=drag._scrollDiffY=0;item._setTranslate(drag._left,drag._top)}function computeThreshold(threshold,safeZone,itemSize,targetSize){THRESHOLD_DATA.value=Math.min(targetSize/2,threshold);THRESHOLD_DATA.offset=Math.max(0,itemSize+THRESHOLD_DATA.value*2+targetSize*safeZone-targetSize)/2;return THRESHOLD_DATA}function ScrollRequest(){this.reset()}ScrollRequest.prototype.reset=function(){if(this.isActive)this.onStop();this.item=null;this.element=null;this.isActive=false;this.isEnding=false;this.direction=null;this.value=null;this.maxValue=0;this.threshold=0;this.distance=0;this.speed=0;this.duration=0;this.action=null};ScrollRequest.prototype.hasReachedEnd=function(){return FORWARD&this.direction?this.value>=this.maxValue:this.value<=0};ScrollRequest.prototype.computeCurrentScrollValue=function(){if(this.value===null){return AXIS_X&this.direction?getScrollLeft(this.element):getScrollTop(this.element)}return Math.max(0,Math.min(this.value,this.maxValue))};ScrollRequest.prototype.computeNextScrollValue=function(deltaTime){var delta=this.speed*(deltaTime/1e3);var nextValue=FORWARD&this.direction?this.value+delta:this.value-delta;return Math.max(0,Math.min(nextValue,this.maxValue))};ScrollRequest.prototype.computeSpeed=function(){var data={direction:null,threshold:0,distance:0,value:0,maxValue:0,deltaTime:0,duration:0,isEnding:false};return function(deltaTime){var item=this.item;var speed=getItemAutoScrollSettings(item).speed;if(isFunction(speed)){data.direction=this.direction;data.threshold=this.threshold;data.distance=this.distance;data.value=this.value;data.maxValue=this.maxValue;data.duration=this.duration;data.speed=this.speed;data.deltaTime=deltaTime;data.isEnding=this.isEnding;return speed(item,this.element,data)}else{return speed}}}();ScrollRequest.prototype.tick=function(deltaTime){if(!this.isActive){this.isActive=true;this.onStart()}this.value=this.computeCurrentScrollValue();this.speed=this.computeSpeed(deltaTime);this.value=this.computeNextScrollValue(deltaTime);this.duration+=deltaTime;return this.value};ScrollRequest.prototype.onStart=function(){var item=this.item;var onStart=getItemAutoScrollSettings(item).onStart;if(isFunction(onStart))onStart(item,this.element,this.direction)};ScrollRequest.prototype.onStop=function(){var item=this.item;var onStop=getItemAutoScrollSettings(item).onStop;if(isFunction(onStop))onStop(item,this.element,this.direction);if(item._drag)item._drag.sort()};function ScrollAction(){this.element=null;this.requestX=null;this.requestY=null;this.scrollLeft=0;this.scrollTop=0}ScrollAction.prototype.reset=function(){if(this.requestX)this.requestX.action=null;if(this.requestY)this.requestY.action=null;this.element=null;this.requestX=null;this.requestY=null;this.scrollLeft=0;this.scrollTop=0};ScrollAction.prototype.addRequest=function(request){if(AXIS_X&request.direction){this.removeRequest(this.requestX);this.requestX=request}else{this.removeRequest(this.requestY);this.requestY=request}request.action=this};ScrollAction.prototype.removeRequest=function(request){if(!request)return;if(this.requestX===request){this.requestX=null;request.action=null}else if(this.requestY===request){this.requestY=null;request.action=null}};ScrollAction.prototype.computeScrollValues=function(){this.scrollLeft=this.requestX?this.requestX.value:getScrollLeft(this.element);this.scrollTop=this.requestY?this.requestY.value:getScrollTop(this.element)};ScrollAction.prototype.scroll=function(){var element=this.element;if(!element)return;if(element.scrollTo){element.scrollTo(this.scrollLeft,this.scrollTop)}else{element.scrollLeft=this.scrollLeft;element.scrollTop=this.scrollTop}};function Pool(createItem,releaseItem){this.pool=[];this.createItem=createItem;this.releaseItem=releaseItem}Pool.prototype.pick=function(){return this.pool.pop()||this.createItem()};Pool.prototype.release=function(item){this.releaseItem(item);if(this.pool.indexOf(item)!==-1)return;this.pool.push(item)};Pool.prototype.reset=function(){this.pool.length=0};function isOverlapping(a,b){return!(a.left+a.width<=b.left||b.left+b.width<=a.left||a.top+a.height<=b.top||b.top+b.height<=a.top)}function getIntersectionArea(a,b){if(!isOverlapping(a,b))return 0;var width=Math.min(a.left+a.width,b.left+b.width)-Math.max(a.left,b.left);var height=Math.min(a.top+a.height,b.top+b.height)-Math.max(a.top,b.top);return width*height}function getIntersectionScore(a,b){var area=getIntersectionArea(a,b);if(!area)return 0;var maxArea=Math.min(a.width,b.width)*Math.min(a.height,b.height);return area/maxArea*100}var RECT_1={width:0,height:0,left:0,right:0,top:0,bottom:0};var RECT_2={width:0,height:0,left:0,right:0,top:0,bottom:0};function AutoScroller(){this._isDestroyed=false;this._isTicking=false;this._tickTime=0;this._tickDeltaTime=0;this._items=[];this._actions=[];this._requests={};this._requests[AXIS_X]={};this._requests[AXIS_Y]={};this._requestOverlapCheck={};this._dragPositions={};this._dragDirections={};this._overlapCheckInterval=150;this._requestPool=new Pool(function(){return new ScrollRequest},function(request){request.reset()});this._actionPool=new Pool(function(){return new ScrollAction},function(action){action.reset()});this._readTick=this._readTick.bind(this);this._writeTick=this._writeTick.bind(this)}AutoScroller.AXIS_X=AXIS_X;AutoScroller.AXIS_Y=AXIS_Y;AutoScroller.FORWARD=FORWARD;AutoScroller.BACKWARD=BACKWARD;AutoScroller.LEFT=LEFT;AutoScroller.RIGHT=RIGHT;AutoScroller.UP=UP;AutoScroller.DOWN=DOWN;AutoScroller.smoothSpeed=function(maxSpeed,acceleration,deceleration){return function(item,element,data){var targetSpeed=0;if(!data.isEnding){if(data.threshold>0){var factor=data.threshold-Math.max(0,data.distance);targetSpeed=maxSpeed/data.threshold*factor}else{targetSpeed=maxSpeed}}var currentSpeed=data.speed;var nextSpeed=targetSpeed;if(currentSpeed===targetSpeed){return nextSpeed}if(currentSpeed<targetSpeed){nextSpeed=currentSpeed+acceleration*(data.deltaTime/1e3);return Math.min(targetSpeed,nextSpeed)}else{nextSpeed=currentSpeed-deceleration*(data.deltaTime/1e3);return Math.max(targetSpeed,nextSpeed)}}};AutoScroller.pointerHandle=function(pointerSize){var rect={left:0,top:0,width:0,height:0};var size=pointerSize||1;return function(item,x,y,w,h,pX,pY){rect.left=pX-size*.5;rect.top=pY-size*.5;rect.width=size;rect.height=size;return rect}};AutoScroller.prototype._readTick=function(time){if(this._isDestroyed)return;if(time&&this._tickTime){this._tickDeltaTime=time-this._tickTime;this._tickTime=time;this._updateRequests();this._updateActions()}else{this._tickTime=time;this._tickDeltaTime=0}};AutoScroller.prototype._writeTick=function(){if(this._isDestroyed)return;this._applyActions();addAutoScrollTick(this._readTick,this._writeTick)};AutoScroller.prototype._startTicking=function(){this._isTicking=true;addAutoScrollTick(this._readTick,this._writeTick)};AutoScroller.prototype._stopTicking=function(){this._isTicking=false;this._tickTime=0;this._tickDeltaTime=0;cancelAutoScrollTick()};AutoScroller.prototype._getItemHandleRect=function(item,handle,rect){var itemDrag=item._drag;if(handle){var ev=itemDrag._dragMoveEvent||itemDrag._dragStartEvent;var data=handle(item,itemDrag._clientX,itemDrag._clientY,item._width,item._height,ev.clientX,ev.clientY);rect.left=data.left;rect.top=data.top;rect.width=data.width;rect.height=data.height}else{rect.left=itemDrag._clientX;rect.top=itemDrag._clientY;rect.width=item._width;rect.height=item._height}rect.right=rect.left+rect.width;rect.bottom=rect.top+rect.height;return rect};AutoScroller.prototype._requestItemScroll=function(item,axis,element,direction,threshold,distance,maxValue){var reqMap=this._requests[axis];var request=reqMap[item._id];if(request){if(request.element!==element||request.direction!==direction){request.reset()}}else{request=this._requestPool.pick()}request.item=item;request.element=element;request.direction=direction;request.threshold=threshold;request.distance=distance;request.maxValue=maxValue;reqMap[item._id]=request};AutoScroller.prototype._cancelItemScroll=function(item,axis){var reqMap=this._requests[axis];var request=reqMap[item._id];if(!request)return;if(request.action)request.action.removeRequest(request);this._requestPool.release(request);delete reqMap[item._id]};AutoScroller.prototype._checkItemOverlap=function(item,checkX,checkY){var settings=getItemAutoScrollSettings(item);var targets=isFunction(settings.targets)?settings.targets(item):settings.targets;var threshold=settings.threshold;var safeZone=settings.safeZone;if(!targets||!targets.length){checkX&&this._cancelItemScroll(item,AXIS_X);checkY&&this._cancelItemScroll(item,AXIS_Y);return}var dragDirections=this._dragDirections[item._id];var dragDirectionX=dragDirections[0];var dragDirectionY=dragDirections[1];if(!dragDirectionX&&!dragDirectionY){checkX&&this._cancelItemScroll(item,AXIS_X);checkY&&this._cancelItemScroll(item,AXIS_Y);return}var itemRect=this._getItemHandleRect(item,settings.handle,RECT_1);var testRect=RECT_2;var target=null;var testElement=null;var testAxisX=true;var testAxisY=true;var testScore=0;var testPriority=0;var testThreshold=null;var testDirection=null;var testDistance=0;var testMaxScrollX=0;var testMaxScrollY=0;var xElement=null;var xPriority=-Infinity;var xThreshold=0;var xScore=0;var xDirection=null;var xDistance=0;var xMaxScroll=0;var yElement=null;var yPriority=-Infinity;var yThreshold=0;var yScore=0;var yDirection=null;var yDistance=0;var yMaxScroll=0;for(var i=0;i<targets.length;i++){target=targets[i];testAxisX=checkX&&dragDirectionX&&target.axis!==AXIS_Y;testAxisY=checkY&&dragDirectionY&&target.axis!==AXIS_X;testPriority=target.priority||0;if((!testAxisX||testPriority<xPriority)&&(!testAxisY||testPriority<yPriority)){continue}testElement=getScrollElement(target.element||target);testMaxScrollX=testAxisX?getScrollLeftMax(testElement):-1;testMaxScrollY=testAxisY?getScrollTopMax(testElement):-1;if(!testMaxScrollX&&!testMaxScrollY)continue;testRect=getContentRect(testElement,testRect);testScore=getIntersectionScore(itemRect,testRect);if(testScore<=0)continue;if(testAxisX&&testPriority>=xPriority&&testMaxScrollX>0&&(testPriority>xPriority||testScore>xScore)){testDirection=null;testThreshold=computeThreshold(typeof target.threshold==="number"?target.threshold:threshold,safeZone,itemRect.width,testRect.width);if(dragDirectionX===RIGHT){testDistance=testRect.right+testThreshold.offset-itemRect.right;if(testDistance<=testThreshold.value&&getScrollLeft(testElement)<testMaxScrollX){testDirection=RIGHT}}else if(dragDirectionX===LEFT){testDistance=itemRect.left-(testRect.left-testThreshold.offset);if(testDistance<=testThreshold.value&&getScrollLeft(testElement)>0){testDirection=LEFT}}if(testDirection!==null){xElement=testElement;xPriority=testPriority;xThreshold=testThreshold.value;xScore=testScore;xDirection=testDirection;xDistance=testDistance;xMaxScroll=testMaxScrollX}}if(testAxisY&&testPriority>=yPriority&&testMaxScrollY>0&&(testPriority>yPriority||testScore>yScore)){testDirection=null;testThreshold=computeThreshold(typeof target.threshold==="number"?target.threshold:threshold,safeZone,itemRect.height,testRect.height);if(dragDirectionY===DOWN){testDistance=testRect.bottom+testThreshold.offset-itemRect.bottom;if(testDistance<=testThreshold.value&&getScrollTop(testElement)<testMaxScrollY){testDirection=DOWN}}else if(dragDirectionY===UP){testDistance=itemRect.top-(testRect.top-testThreshold.offset);if(testDistance<=testThreshold.value&&getScrollTop(testElement)>0){testDirection=UP}}if(testDirection!==null){yElement=testElement;yPriority=testPriority;yThreshold=testThreshold.value;yScore=testScore;yDirection=testDirection;yDistance=testDistance;yMaxScroll=testMaxScrollY}}}if(checkX){if(xElement){this._requestItemScroll(item,AXIS_X,xElement,xDirection,xThreshold,xDistance,xMaxScroll)}else{this._cancelItemScroll(item,AXIS_X)}}if(checkY){if(yElement){this._requestItemScroll(item,AXIS_Y,yElement,yDirection,yThreshold,yDistance,yMaxScroll)}else{this._cancelItemScroll(item,AXIS_Y)}}};AutoScroller.prototype._updateScrollRequest=function(scrollRequest){var item=scrollRequest.item;var settings=getItemAutoScrollSettings(item);var targets=isFunction(settings.targets)?settings.targets(item):settings.targets;var targetCount=targets&&targets.length||0;var threshold=settings.threshold;var safeZone=settings.safeZone;var itemRect=this._getItemHandleRect(item,settings.handle,RECT_1);var testRect=RECT_2;var target=null;var testElement=null;var testIsAxisX=false;var testScore=null;var testThreshold=null;var testDistance=null;var testScroll=null;var testMaxScroll=null;var hasReachedEnd=null;for(var i=0;i<targetCount;i++){target=targets[i];testElement=getScrollElement(target.element||target);if(testElement!==scrollRequest.element)continue;testIsAxisX=!!(AXIS_X&scrollRequest.direction);if(testIsAxisX){if(target.axis===AXIS_Y)continue}else{if(target.axis===AXIS_X)continue}testMaxScroll=testIsAxisX?getScrollLeftMax(testElement):getScrollTopMax(testElement);if(testMaxScroll<=0){break}testRect=getContentRect(testElement,testRect);testScore=getIntersectionScore(itemRect,testRect);if(testScore<=0){break}testThreshold=computeThreshold(typeof target.threshold==="number"?target.threshold:threshold,safeZone,testIsAxisX?itemRect.width:itemRect.height,testIsAxisX?testRect.width:testRect.height);if(scrollRequest.direction===LEFT){testDistance=itemRect.left-(testRect.left-testThreshold.offset)}else if(scrollRequest.direction===RIGHT){testDistance=testRect.right+testThreshold.offset-itemRect.right}else if(scrollRequest.direction===UP){testDistance=itemRect.top-(testRect.top-testThreshold.offset)}else{testDistance=testRect.bottom+testThreshold.offset-itemRect.bottom}if(testDistance>testThreshold.value){break}testScroll=testIsAxisX?getScrollLeft(testElement):getScrollTop(testElement);hasReachedEnd=FORWARD&scrollRequest.direction?testScroll>=testMaxScroll:testScroll<=0;if(hasReachedEnd){break}scrollRequest.maxValue=testMaxScroll;scrollRequest.threshold=testThreshold.value;scrollRequest.distance=testDistance;scrollRequest.isEnding=false;return true}if(settings.smoothStop===true&&scrollRequest.speed>0){if(hasReachedEnd===null)hasReachedEnd=scrollRequest.hasReachedEnd();scrollRequest.isEnding=hasReachedEnd?false:true}else{scrollRequest.isEnding=false}return scrollRequest.isEnding};AutoScroller.prototype._updateRequests=function(){var items=this._items;var requestsX=this._requests[AXIS_X];var requestsY=this._requests[AXIS_Y];var item,reqX,reqY,checkTime,needsCheck,checkX,checkY;for(var i=0;i<items.length;i++){item=items[i];checkTime=this._requestOverlapCheck[item._id];needsCheck=checkTime>0&&this._tickTime-checkTime>this._overlapCheckInterval;checkX=true;reqX=requestsX[item._id];if(reqX&&reqX.isActive){checkX=!this._updateScrollRequest(reqX);if(checkX){needsCheck=true;this._cancelItemScroll(item,AXIS_X)}}checkY=true;reqY=requestsY[item._id];if(reqY&&reqY.isActive){checkY=!this._updateScrollRequest(reqY);if(checkY){needsCheck=true;this._cancelItemScroll(item,AXIS_Y)}}if(needsCheck){this._requestOverlapCheck[item._id]=0;this._checkItemOverlap(item,checkX,checkY)}}};AutoScroller.prototype._requestAction=function(request,axis){var actions=this._actions;var isAxisX=axis===AXIS_X;var action=null;for(var i=0;i<actions.length;i++){action=actions[i];if(request.element!==action.element){action=null;continue}if(isAxisX?action.requestX:action.requestY){this._cancelItemScroll(request.item,axis);return}break}if(!action)action=this._actionPool.pick();action.element=request.element;action.addRequest(request);request.tick(this._tickDeltaTime);actions.push(action)};AutoScroller.prototype._updateActions=function(){var items=this._items;var requests=this._requests;var actions=this._actions;var itemId;var reqX;var reqY;var i;for(i=0;i<items.length;i++){itemId=items[i]._id;reqX=requests[AXIS_X][itemId];reqY=requests[AXIS_Y][itemId];if(reqX)this._requestAction(reqX,AXIS_X);if(reqY)this._requestAction(reqY,AXIS_Y)}for(i=0;i<actions.length;i++){actions[i].computeScrollValues()}};AutoScroller.prototype._applyActions=function(){var actions=this._actions;var items=this._items;var i;if(!actions.length)return;for(i=0;i<actions.length;i++){actions[i].scroll();this._actionPool.release(actions[i])}actions.length=0;for(i=0;i<items.length;i++)prepareItemScrollSync(items[i]);for(i=0;i<items.length;i++)applyItemScrollSync(items[i])};AutoScroller.prototype._updateDragDirection=function(item){var dragPositions=this._dragPositions[item._id];var dragDirections=this._dragDirections[item._id];var x1=item._drag._left;var y1=item._drag._top;if(dragPositions.length){var x2=dragPositions[0];var y2=dragPositions[1];dragDirections[0]=x1>x2?RIGHT:x1<x2?LEFT:dragDirections[0]||0;dragDirections[1]=y1>y2?DOWN:y1<y2?UP:dragDirections[1]||0}dragPositions[0]=x1;dragPositions[1]=y1};AutoScroller.prototype.addItem=function(item){if(this._isDestroyed)return;var index=this._items.indexOf(item);if(index===-1){this._items.push(item);this._requestOverlapCheck[item._id]=this._tickTime;this._dragDirections[item._id]=[0,0];this._dragPositions[item._id]=[];if(!this._isTicking)this._startTicking()}};AutoScroller.prototype.updateItem=function(item){if(this._isDestroyed)return;if(!this._dragDirections[item._id])return;this._updateDragDirection(item);if(!this._requestOverlapCheck[item._id]){this._requestOverlapCheck[item._id]=this._tickTime}};AutoScroller.prototype.removeItem=function(item){if(this._isDestroyed)return;var index=this._items.indexOf(item);if(index===-1)return;var itemId=item._id;var reqX=this._requests[AXIS_X][itemId];if(reqX){this._cancelItemScroll(item,AXIS_X);delete this._requests[AXIS_X][itemId]}var reqY=this._requests[AXIS_Y][itemId];if(reqY){this._cancelItemScroll(item,AXIS_Y);delete this._requests[AXIS_Y][itemId]}delete this._requestOverlapCheck[itemId];delete this._dragPositions[itemId];delete this._dragDirections[itemId];this._items.splice(index,1);if(this._isTicking&&!this._items.length){this._stopTicking()}};AutoScroller.prototype.isItemScrollingX=function(item){var reqX=this._requests[AXIS_X][item._id];return!!(reqX&&reqX.isActive)};AutoScroller.prototype.isItemScrollingY=function(item){var reqY=this._requests[AXIS_Y][item._id];return!!(reqY&&reqY.isActive)};AutoScroller.prototype.isItemScrolling=function(item){return this.isItemScrollingX(item)||this.isItemScrollingY(item)};AutoScroller.prototype.destroy=function(){if(this._isDestroyed)return;var items=this._items.slice(0);for(var i=0;i<items.length;i++){this.removeItem(items[i])}this._actions.length=0;this._requestPool.reset();this._actionPool.reset();this._isDestroyed=true};var ElProto=window.Element.prototype;var matchesFn=ElProto.matches||ElProto.matchesSelector||ElProto.webkitMatchesSelector||ElProto.mozMatchesSelector||ElProto.msMatchesSelector||ElProto.oMatchesSelector||function(){return false};function elementMatches(el,selector){return matchesFn.call(el,selector)}function addClass(element,className){if(!className)return;if(element.classList){element.classList.add(className)}else{if(!elementMatches(element,"."+className)){element.className+=" "+className}}}var tempArray=[];var numberType="number";function arrayInsert(array,items,index){var startIndex=typeof index===numberType?index:-1;if(startIndex<0)startIndex=array.length-startIndex+1;array.splice.apply(array,tempArray.concat(startIndex,0,items));tempArray.length=0}function normalizeArrayIndex(array,index,sizeOffset){var maxIndex=Math.max(0,array.length-1+(sizeOffset||0));return index>maxIndex?maxIndex:index<0?Math.max(maxIndex+index+1,0):index}function arrayMove(array,fromIndex,toIndex){if(array.length<2)return;var from=normalizeArrayIndex(array,fromIndex);var to=normalizeArrayIndex(array,toIndex);if(from!==to){array.splice(to,0,array.splice(from,1)[0])}}function arraySwap(array,index,withIndex){if(array.length<2)return;var indexA=normalizeArrayIndex(array,index);var indexB=normalizeArrayIndex(array,withIndex);var temp;if(indexA!==indexB){temp=array[indexA];array[indexA]=array[indexB];array[indexB]=temp}}var transformProp=getPrefixedPropName(document.documentElement.style,"transform")||"transform";var styleNameRegEx=/([A-Z])/g;var prefixRegex=/^(webkit-|moz-|ms-|o-)/;var msPrefixRegex=/^(-m-s-)/;function getStyleName(property){var styleName=property.replace(styleNameRegEx,"-$1").toLowerCase();styleName=styleName.replace(prefixRegex,"-$1");styleName=styleName.replace(msPrefixRegex,"-ms-");return styleName}var transformStyle=getStyleName(transformProp);var transformNone$1="none";var displayInline="inline";var displayNone="none";var displayStyle="display";function isTransformed(element){var transform=getStyle(element,transformStyle);if(!transform||transform===transformNone$1)return false;var display=getStyle(element,displayStyle);if(display===displayInline||display===displayNone)return false;return true}function getContainingBlock(element){var doc=document;var res=element||doc;while(res&&res!==doc&&getStyle(res,"position")==="static"&&!isTransformed(res)){res=res.parentElement||doc}return res}var offsetA={};var offsetB={};var offsetDiff={};function getOffset(element,offsetData){var offset=offsetData||{};var rect;offset.left=0;offset.top=0;if(element===document)return offset;offset.left=window.pageXOffset||0;offset.top=window.pageYOffset||0;if(element.self===window.self)return offset;rect=element.getBoundingClientRect();offset.left+=rect.left;offset.top+=rect.top;offset.left+=getStyleAsFloat(element,"border-left-width");offset.top+=getStyleAsFloat(element,"border-top-width");return offset}function getOffsetDiff(elemA,elemB,compareContainingBlocks){offsetDiff.left=0;offsetDiff.top=0;if(elemA===elemB)return offsetDiff;if(compareContainingBlocks){elemA=getContainingBlock(elemA);elemB=getContainingBlock(elemB);if(elemA===elemB)return offsetDiff}getOffset(elemA,offsetA);getOffset(elemB,offsetB);offsetDiff.left=offsetB.left-offsetA.left;offsetDiff.top=offsetB.top-offsetA.top;return offsetDiff}function isScrollableOverflow(value){return value==="auto"||value==="scroll"||value==="overlay"}function isScrollable(element){return isScrollableOverflow(getStyle(element,"overflow"))||isScrollableOverflow(getStyle(element,"overflow-x"))||isScrollableOverflow(getStyle(element,"overflow-y"))}function getScrollableAncestors(element,result){result=result||[];while(element&&element!==document){if(element.getRootNode&&element instanceof DocumentFragment){element=element.getRootNode().host;continue}if(isScrollable(element)){result.push(element)}element=element.parentNode}result.push(window);return result}var translateValue={};var transformNone="none";var rxMat3d=/^matrix3d/;var rxMatTx=/([^,]*,){4}/;var rxMat3dTx=/([^,]*,){12}/;var rxNextItem=/[^,]*,/;function getTranslate(element){translateValue.x=0;translateValue.y=0;var transform=getStyle(element,transformStyle);if(!transform||transform===transformNone){return translateValue}var isMat3d=rxMat3d.test(transform);var tX=transform.replace(isMat3d?rxMat3dTx:rxMatTx,"");var tY=tX.replace(rxNextItem,"");translateValue.x=parseFloat(tX)||0;translateValue.y=parseFloat(tY)||0;return translateValue}function removeClass(element,className){if(!className)return;if(element.classList){element.classList.remove(className)}else{if(elementMatches(element,"."+className)){element.className=(" "+element.className+" ").replace(" "+className+" "," ").trim()}}}var IS_IOS=/^(iPad|iPhone|iPod)/.test(window.navigator.platform)||/^Mac/.test(window.navigator.platform)&&window.navigator.maxTouchPoints>1;var START_PREDICATE_INACTIVE=0;var START_PREDICATE_PENDING=1;var START_PREDICATE_RESOLVED=2;var SCROLL_LISTENER_OPTIONS=hasPassiveEvents()?{passive:true}:false;function ItemDrag(item){var element=item._element;var grid=item.getGrid();var settings=grid._settings;this._item=item;this._gridId=grid._id;this._isDestroyed=false;this._isMigrating=false;this._startPredicate=isFunction(settings.dragStartPredicate)?settings.dragStartPredicate:ItemDrag.defaultStartPredicate;this._startPredicateState=START_PREDICATE_INACTIVE;this._startPredicateResult=undefined;this._isSortNeeded=false;this._sortTimer=undefined;this._blockedSortIndex=null;this._sortX1=0;this._sortX2=0;this._sortY1=0;this._sortY2=0;this._reset();this._preStartCheck=this._preStartCheck.bind(this);this._preEndCheck=this._preEndCheck.bind(this);this._onScroll=this._onScroll.bind(this);this._prepareStart=this._prepareStart.bind(this);this._applyStart=this._applyStart.bind(this);this._prepareMove=this._prepareMove.bind(this);this._applyMove=this._applyMove.bind(this);this._prepareScroll=this._prepareScroll.bind(this);this._applyScroll=this._applyScroll.bind(this);this._handleSort=this._handleSort.bind(this);this._handleSortDelayed=this._handleSortDelayed.bind(this);this._handle=settings.dragHandle&&element.querySelector(settings.dragHandle)||element;this._dragger=new Dragger(this._handle,settings.dragCssProps);this._dragger.on("start",this._preStartCheck);this._dragger.on("move",this._preStartCheck);this._dragger.on("cancel",this._preEndCheck);this._dragger.on("end",this._preEndCheck)}ItemDrag.autoScroller=new AutoScroller;ItemDrag.defaultStartPredicate=function(item,event,options){var drag=item._drag;if(event.isFirst&&event.srcEvent.button){return false}if(!IS_IOS&&event.isFirst&&event.srcEvent.isTrusted===true&&event.srcEvent.defaultPrevented===false&&event.srcEvent.cancelable===false){return false}if(event.isFinal){drag._finishStartPredicate(event);return}var predicate=drag._startPredicateData;if(!predicate){var config=options||drag._getGrid()._settings.dragStartPredicate||{};drag._startPredicateData=predicate={distance:Math.max(config.distance,0)||0,delay:Math.max(config.delay,0)||0}}if(predicate.delay){predicate.event=event;if(!predicate.delayTimer){predicate.delayTimer=window.setTimeout(function(){predicate.delay=0;if(drag._resolveStartPredicate(predicate.event)){drag._forceResolveStartPredicate(predicate.event);drag._resetStartPredicate()}},predicate.delay)}}return drag._resolveStartPredicate(event)};ItemDrag.defaultSortPredicate=function(){var itemRect={};var targetRect={};var returnData={};var gridsArray=[];var minThreshold=1;var maxThreshold=100;function getTargetGrid(item,rootGrid,threshold){var target=null;var dragSort=rootGrid._settings.dragSort;var bestScore=-1;var gridScore;var grids;var grid;var container;var containerRect;var left;var top;var right;var bottom;var i;if(dragSort===true){gridsArray[0]=rootGrid;grids=gridsArray}else if(isFunction(dragSort)){grids=dragSort.call(rootGrid,item)}if(!grids||!Array.isArray(grids)||!grids.length){return target}for(i=0;i<grids.length;i++){grid=grids[i];if(grid._isDestroyed)continue;grid._updateBoundingRect();left=Math.max(0,grid._left);top=Math.max(0,grid._top);right=Math.min(window.innerWidth,grid._right);bottom=Math.min(window.innerHeight,grid._bottom);container=grid._element.parentNode;while(container&&container!==document&&container!==document.documentElement&&container!==document.body){if(container.getRootNode&&container instanceof DocumentFragment){container=container.getRootNode().host;continue}if(getStyle(container,"overflow")!=="visible"){containerRect=container.getBoundingClientRect();left=Math.max(left,containerRect.left);top=Math.max(top,containerRect.top);right=Math.min(right,containerRect.right);bottom=Math.min(bottom,containerRect.bottom)}if(getStyle(container,"position")==="fixed"){break}container=container.parentNode}if(left>=right||top>=bottom)continue;targetRect.left=left;targetRect.top=top;targetRect.width=right-left;targetRect.height=bottom-top;gridScore=getIntersectionScore(itemRect,targetRect);if(gridScore>threshold&&gridScore>bestScore){bestScore=gridScore;target=grid}}gridsArray.length=0;return target}return function(item,options){var drag=item._drag;var rootGrid=drag._getGrid();var sortThreshold=options&&typeof options.threshold==="number"?options.threshold:50;var sortAction=options&&options.action===ACTION_SWAP?ACTION_SWAP:ACTION_MOVE;var migrateAction=options&&options.migrateAction===ACTION_SWAP?ACTION_SWAP:ACTION_MOVE;sortThreshold=Math.min(Math.max(sortThreshold,minThreshold),maxThreshold);itemRect.width=item._width;itemRect.height=item._height;itemRect.left=drag._clientX;itemRect.top=drag._clientY;var grid=getTargetGrid(item,rootGrid,sortThreshold);if(!grid)return null;var isMigration=item.getGrid()!==grid;var gridOffsetLeft=0;var gridOffsetTop=0;var matchScore=0;var matchIndex=-1;var hasValidTargets=false;var target;var score;var i;if(grid===rootGrid){itemRect.left=drag._gridX+item._marginLeft;itemRect.top=drag._gridY+item._marginTop}else{grid._updateBorders(1,0,1,0);gridOffsetLeft=grid._left+grid._borderLeft;gridOffsetTop=grid._top+grid._borderTop}for(i=0;i<grid._items.length;i++){target=grid._items[i];if(!target._isActive||target===item){continue}hasValidTargets=true;targetRect.width=target._width;targetRect.height=target._height;targetRect.left=target._left+target._marginLeft+gridOffsetLeft;targetRect.top=target._top+target._marginTop+gridOffsetTop;score=getIntersectionScore(itemRect,targetRect);if(score>matchScore){matchIndex=i;matchScore=score}}if(isMigration&&matchScore<sortThreshold){matchIndex=hasValidTargets?matchIndex:0;matchScore=sortThreshold}if(matchScore>=sortThreshold){returnData.grid=grid;returnData.index=matchIndex;returnData.action=isMigration?migrateAction:sortAction;return returnData}return null}}();ItemDrag.prototype.stop=function(){if(!this._isActive)return;if(this._isMigrating){this._finishMigration();return}var item=this._item;var itemId=item._id;ItemDrag.autoScroller.removeItem(item);cancelDragStartTick(itemId);cancelDragMoveTick(itemId);cancelDragScrollTick(itemId);this._cancelSort();if(this._isStarted){this._unbindScrollListeners();var element=item._element;var grid=this._getGrid();var draggingClass=grid._settings.itemDraggingClass;if(element.parentNode!==grid._element){grid._element.appendChild(element);item._setTranslate(this._gridX,this._gridY);if(draggingClass)element.clientWidth}removeClass(element,draggingClass)}this._reset()};ItemDrag.prototype.sort=function(force){var item=this._item;if(this._isActive&&item._isActive&&this._dragMoveEvent){if(force===true){this._handleSort()}else{addDragSortTick(item._id,this._handleSort)}}};ItemDrag.prototype.destroy=function(){if(this._isDestroyed)return;this.stop();this._dragger.destroy();ItemDrag.autoScroller.removeItem(this._item);this._isDestroyed=true};ItemDrag.prototype._getGrid=function(){return GRID_INSTANCES[this._gridId]||null};ItemDrag.prototype._reset=function(){this._isActive=false;this._isStarted=false;this._container=null;this._containingBlock=null;this._dragStartEvent=null;this._dragMoveEvent=null;this._dragPrevMoveEvent=null;this._scrollEvent=null;this._scrollers=[];this._left=0;this._top=0;this._gridX=0;this._gridY=0;this._clientX=0;this._clientY=0;this._scrollDiffX=0;this._scrollDiffY=0;this._moveDiffX=0;this._moveDiffY=0;this._containerDiffX=0;this._containerDiffY=0};ItemDrag.prototype._bindScrollListeners=function(){var gridContainer=this._getGrid()._element;var dragContainer=this._container;var scrollers=this._scrollers;var gridScrollers;var i;scrollers.length=0;getScrollableAncestors(this._item._element.parentNode,scrollers);if(dragContainer!==gridContainer){gridScrollers=[];getScrollableAncestors(gridContainer,gridScrollers);for(i=0;i<gridScrollers.length;i++){if(scrollers.indexOf(gridScrollers[i])<0){scrollers.push(gridScrollers[i])}}}for(i=0;i<scrollers.length;i++){scrollers[i].addEventListener("scroll",this._onScroll,SCROLL_LISTENER_OPTIONS)}};ItemDrag.prototype._unbindScrollListeners=function(){var scrollers=this._scrollers;var i;for(i=0;i<scrollers.length;i++){scrollers[i].removeEventListener("scroll",this._onScroll,SCROLL_LISTENER_OPTIONS)}scrollers.length=0};ItemDrag.prototype._resolveStartPredicate=function(event){var predicate=this._startPredicateData;if(event.distance<predicate.distance||predicate.delay)return;this._resetStartPredicate();return true};ItemDrag.prototype._forceResolveStartPredicate=function(event){if(!this._isDestroyed&&this._startPredicateState===START_PREDICATE_PENDING){this._startPredicateState=START_PREDICATE_RESOLVED;this._onStart(event)}};ItemDrag.prototype._finishStartPredicate=function(event){var element=this._item._element;var isClick=Math.abs(event.deltaX)<2&&Math.abs(event.deltaY)<2&&event.deltaTime<200;this._resetStartPredicate();if(isClick)openAnchorHref(element)};ItemDrag.prototype._resetHeuristics=function(x,y){this._blockedSortIndex=null;this._sortX1=this._sortX2=x;this._sortY1=this._sortY2=y};ItemDrag.prototype._checkHeuristics=function(x,y){var settings=this._getGrid()._settings.dragSortHeuristics;var minDist=settings.minDragDistance;if(minDist<=0){this._blockedSortIndex=null;return true}var diffX=x-this._sortX2;var diffY=y-this._sortY2;var canCheckBounceBack=minDist>3&&settings.minBounceBackAngle>0;if(!canCheckBounceBack){this._blockedSortIndex=null}if(Math.abs(diffX)>minDist||Math.abs(diffY)>minDist){if(canCheckBounceBack){var angle=Math.atan2(diffX,diffY);var prevAngle=Math.atan2(this._sortX2-this._sortX1,this._sortY2-this._sortY1);var deltaAngle=Math.atan2(Math.sin(angle-prevAngle),Math.cos(angle-prevAngle));if(Math.abs(deltaAngle)>settings.minBounceBackAngle){this._blockedSortIndex=null}}this._sortX1=this._sortX2;this._sortY1=this._sortY2;this._sortX2=x;this._sortY2=y;return true}return false};ItemDrag.prototype._resetStartPredicate=function(){var predicate=this._startPredicateData;if(predicate){if(predicate.delayTimer){predicate.delayTimer=window.clearTimeout(predicate.delayTimer)}this._startPredicateData=null}};ItemDrag.prototype._handleSort=function(){if(!this._isActive)return;var settings=this._getGrid()._settings;if(!settings.dragSort||!settings.dragAutoScroll.sortDuringScroll&&ItemDrag.autoScroller.isItemScrolling(this._item)){this._sortX1=this._sortX2=this._gridX;this._sortY1=this._sortY2=this._gridY;this._isSortNeeded=true;if(this._sortTimer!==undefined){this._sortTimer=window.clearTimeout(this._sortTimer)}return}var shouldSort=this._checkHeuristics(this._gridX,this._gridY);if(!this._isSortNeeded&&!shouldSort)return;var sortInterval=settings.dragSortHeuristics.sortInterval;if(sortInterval<=0||this._isSortNeeded){this._isSortNeeded=false;if(this._sortTimer!==undefined){this._sortTimer=window.clearTimeout(this._sortTimer)}this._checkOverlap()}else if(this._sortTimer===undefined){this._sortTimer=window.setTimeout(this._handleSortDelayed,sortInterval)}};ItemDrag.prototype._handleSortDelayed=function(){this._isSortNeeded=true;this._sortTimer=undefined;addDragSortTick(this._item._id,this._handleSort)};ItemDrag.prototype._cancelSort=function(){this._isSortNeeded=false;if(this._sortTimer!==undefined){this._sortTimer=window.clearTimeout(this._sortTimer)}cancelDragSortTick(this._item._id)};ItemDrag.prototype._finishSort=function(){var isSortEnabled=this._getGrid()._settings.dragSort;var needsFinalCheck=isSortEnabled&&(this._isSortNeeded||this._sortTimer!==undefined);this._cancelSort();if(needsFinalCheck)this._checkOverlap()};ItemDrag.prototype._checkOverlap=function(){if(!this._isActive)return;var item=this._item;var settings=this._getGrid()._settings;var result;var currentGrid;var currentIndex;var targetGrid;var targetIndex;var targetItem;var sortAction;var isMigration;if(isFunction(settings.dragSortPredicate)){result=settings.dragSortPredicate(item,this._dragMoveEvent)}else{result=ItemDrag.defaultSortPredicate(item,settings.dragSortPredicate)}if(!result||typeof result.index!=="number")return;sortAction=result.action===ACTION_SWAP?ACTION_SWAP:ACTION_MOVE;currentGrid=item.getGrid();targetGrid=result.grid||currentGrid;isMigration=currentGrid!==targetGrid;currentIndex=currentGrid._items.indexOf(item);targetIndex=normalizeArrayIndex(targetGrid._items,result.index,isMigration&&sortAction===ACTION_MOVE?1:0);if(!isMigration&&targetIndex===this._blockedSortIndex){return}if(!isMigration){if(currentIndex!==targetIndex){this._blockedSortIndex=currentIndex;(sortAction===ACTION_SWAP?arraySwap:arrayMove)(currentGrid._items,currentIndex,targetIndex);if(currentGrid._hasListeners(EVENT_MOVE)){currentGrid._emit(EVENT_MOVE,{item:item,fromIndex:currentIndex,toIndex:targetIndex,action:sortAction})}currentGrid.layout()}}else{this._blockedSortIndex=null;targetItem=targetGrid._items[targetIndex];if(currentGrid._hasListeners(EVENT_BEFORE_SEND)){currentGrid._emit(EVENT_BEFORE_SEND,{item:item,fromGrid:currentGrid,fromIndex:currentIndex,toGrid:targetGrid,toIndex:targetIndex})}if(targetGrid._hasListeners(EVENT_BEFORE_RECEIVE)){targetGrid._emit(EVENT_BEFORE_RECEIVE,{item:item,fromGrid:currentGrid,fromIndex:currentIndex,toGrid:targetGrid,toIndex:targetIndex})}item._gridId=targetGrid._id;this._isMigrating=item._gridId!==this._gridId;currentGrid._items.splice(currentIndex,1);arrayInsert(targetGrid._items,item,targetIndex);item._sortData=null;if(currentGrid._hasListeners(EVENT_SEND)){currentGrid._emit(EVENT_SEND,{item:item,fromGrid:currentGrid,fromIndex:currentIndex,toGrid:targetGrid,toIndex:targetIndex})}if(targetGrid._hasListeners(EVENT_RECEIVE)){targetGrid._emit(EVENT_RECEIVE,{item:item,fromGrid:currentGrid,fromIndex:currentIndex,toGrid:targetGrid,toIndex:targetIndex})}if(sortAction===ACTION_SWAP&&targetItem&&targetItem.isActive()){if(targetGrid._items.indexOf(targetItem)>-1){targetGrid.send(targetItem,currentGrid,currentIndex,{appendTo:this._container||document.body,layoutSender:false,layoutReceiver:false})}}currentGrid.layout();targetGrid.layout()}};ItemDrag.prototype._finishMigration=function(){var item=this._item;var release=item._dragRelease;var element=item._element;var isActive=item._isActive;var targetGrid=item.getGrid();var targetGridElement=targetGrid._element;var targetSettings=targetGrid._settings;var targetContainer=targetSettings.dragContainer||targetGridElement;var currentSettings=this._getGrid()._settings;var currentContainer=element.parentNode;var currentVisClass=isActive?currentSettings.itemVisibleClass:currentSettings.itemHiddenClass;var nextVisClass=isActive?targetSettings.itemVisibleClass:targetSettings.itemHiddenClass;var translate;var offsetDiff;this._isMigrating=false;this.destroy();if(currentSettings.itemClass!==targetSettings.itemClass){removeClass(element,currentSettings.itemClass);addClass(element,targetSettings.itemClass)}if(currentVisClass!==nextVisClass){removeClass(element,currentVisClass);addClass(element,nextVisClass)}if(targetContainer!==currentContainer){targetContainer.appendChild(element);offsetDiff=getOffsetDiff(currentContainer,targetContainer,true);translate=getTranslate(element);translate.x-=offsetDiff.left;translate.y-=offsetDiff.top}item._refreshDimensions();offsetDiff=getOffsetDiff(targetContainer,targetGridElement,true);release._containerDiffX=offsetDiff.left;release._containerDiffY=offsetDiff.top;item._drag=targetSettings.dragEnabled?new ItemDrag(item):null;if(targetContainer!==currentContainer){item._setTranslate(translate.x,translate.y)}item._visibility.setStyles(isActive?targetSettings.visibleStyles:targetSettings.hiddenStyles);release.start()};ItemDrag.prototype._preStartCheck=function(event){if(this._startPredicateState===START_PREDICATE_INACTIVE){this._startPredicateState=START_PREDICATE_PENDING}if(this._startPredicateState===START_PREDICATE_PENDING){this._startPredicateResult=this._startPredicate(this._item,event);if(this._startPredicateResult===true){this._startPredicateState=START_PREDICATE_RESOLVED;this._onStart(event)}else if(this._startPredicateResult===false){this._resetStartPredicate(event);this._dragger._reset();this._startPredicateState=START_PREDICATE_INACTIVE}}else if(this._startPredicateState===START_PREDICATE_RESOLVED&&this._isActive){this._onMove(event)}};ItemDrag.prototype._preEndCheck=function(event){var isResolved=this._startPredicateState===START_PREDICATE_RESOLVED;this._startPredicate(this._item,event);this._startPredicateState=START_PREDICATE_INACTIVE;if(!isResolved||!this._isActive)return;if(this._isStarted){this._onEnd(event)}else{this.stop()}};ItemDrag.prototype._onStart=function(event){var item=this._item;if(!item._isActive)return;this._isActive=true;this._dragStartEvent=event;ItemDrag.autoScroller.addItem(item);addDragStartTick(item._id,this._prepareStart,this._applyStart)};ItemDrag.prototype._prepareStart=function(){if(!this._isActive)return;var item=this._item;if(!item._isActive)return;var element=item._element;var grid=this._getGrid();var settings=grid._settings;var gridContainer=grid._element;var dragContainer=settings.dragContainer||gridContainer;var containingBlock=getContainingBlock(dragContainer);var translate=getTranslate(element);var elementRect=element.getBoundingClientRect();var hasDragContainer=dragContainer!==gridContainer;this._container=dragContainer;this._containingBlock=containingBlock;this._clientX=elementRect.left;this._clientY=elementRect.top;this._left=this._gridX=translate.x;this._top=this._gridY=translate.y;this._scrollDiffX=this._scrollDiffY=0;this._moveDiffX=this._moveDiffY=0;this._resetHeuristics(this._gridX,this._gridY);if(hasDragContainer){var offsetDiff=getOffsetDiff(containingBlock,gridContainer);this._containerDiffX=offsetDiff.left;this._containerDiffY=offsetDiff.top}};ItemDrag.prototype._applyStart=function(){if(!this._isActive)return;var item=this._item;if(!item._isActive)return;var grid=this._getGrid();var element=item._element;var release=item._dragRelease;var migrate=item._migrate;var hasDragContainer=this._container!==grid._element;if(item.isPositioning()){item._layout.stop(true,this._left,this._top)}if(migrate._isActive){this._left-=migrate._containerDiffX;this._top-=migrate._containerDiffY;this._gridX-=migrate._containerDiffX;this._gridY-=migrate._containerDiffY;migrate.stop(true,this._left,this._top)}if(item.isReleasing()){release._reset()}if(grid._settings.dragPlaceholder.enabled){item._dragPlaceholder.create()}this._isStarted=true;grid._emit(EVENT_DRAG_INIT,item,this._dragStartEvent);if(hasDragContainer){if(element.parentNode===this._container){this._gridX-=this._containerDiffX;this._gridY-=this._containerDiffY}else{this._left+=this._containerDiffX;this._top+=this._containerDiffY;this._container.appendChild(element);item._setTranslate(this._left,this._top)}}addClass(element,grid._settings.itemDraggingClass);this._bindScrollListeners();grid._emit(EVENT_DRAG_START,item,this._dragStartEvent)};ItemDrag.prototype._onMove=function(event){var item=this._item;if(!item._isActive){this.stop();return}this._dragMoveEvent=event;addDragMoveTick(item._id,this._prepareMove,this._applyMove);addDragSortTick(item._id,this._handleSort)};ItemDrag.prototype._prepareMove=function(){if(!this._isActive)return;var item=this._item;if(!item._isActive)return;var settings=this._getGrid()._settings;var axis=settings.dragAxis;var nextEvent=this._dragMoveEvent;var prevEvent=this._dragPrevMoveEvent||this._dragStartEvent||nextEvent;if(axis!=="y"){var moveDiffX=nextEvent.clientX-prevEvent.clientX;this._left=this._left-this._moveDiffX+moveDiffX;this._gridX=this._gridX-this._moveDiffX+moveDiffX;this._clientX=this._clientX-this._moveDiffX+moveDiffX;this._moveDiffX=moveDiffX}if(axis!=="x"){var moveDiffY=nextEvent.clientY-prevEvent.clientY;this._top=this._top-this._moveDiffY+moveDiffY;this._gridY=this._gridY-this._moveDiffY+moveDiffY;this._clientY=this._clientY-this._moveDiffY+moveDiffY;this._moveDiffY=moveDiffY}this._dragPrevMoveEvent=nextEvent};ItemDrag.prototype._applyMove=function(){if(!this._isActive)return;var item=this._item;if(!item._isActive)return;this._moveDiffX=this._moveDiffY=0;item._setTranslate(this._left,this._top);this._getGrid()._emit(EVENT_DRAG_MOVE,item,this._dragMoveEvent);ItemDrag.autoScroller.updateItem(item)};ItemDrag.prototype._onScroll=function(event){var item=this._item;if(!item._isActive){this.stop();return}this._scrollEvent=event;addDragScrollTick(item._id,this._prepareScroll,this._applyScroll);addDragSortTick(item._id,this._handleSort)};ItemDrag.prototype._prepareScroll=function(){if(!this._isActive)return;var item=this._item;if(!item._isActive)return;var element=item._element;var grid=this._getGrid();var gridContainer=grid._element;var rect=element.getBoundingClientRect();if(this._container!==gridContainer){var offsetDiff=getOffsetDiff(this._containingBlock,gridContainer);this._containerDiffX=offsetDiff.left;this._containerDiffY=offsetDiff.top}var scrollDiffX=this._clientX-this._moveDiffX-rect.left;this._left=this._left-this._scrollDiffX+scrollDiffX;this._scrollDiffX=scrollDiffX;var scrollDiffY=this._clientY-this._moveDiffY-rect.top;this._top=this._top-this._scrollDiffY+scrollDiffY;this._scrollDiffY=scrollDiffY;this._gridX=this._left-this._containerDiffX;this._gridY=this._top-this._containerDiffY};ItemDrag.prototype._applyScroll=function(){if(!this._isActive)return;var item=this._item;if(!item._isActive)return;this._scrollDiffX=this._scrollDiffY=0;item._setTranslate(this._left,this._top);this._getGrid()._emit(EVENT_DRAG_SCROLL,item,this._scrollEvent)};ItemDrag.prototype._onEnd=function(event){var item=this._item;var element=item._element;var grid=this._getGrid();var settings=grid._settings;var release=item._dragRelease;if(!item._isActive){this.stop();return}cancelDragStartTick(item._id);cancelDragMoveTick(item._id);cancelDragScrollTick(item._id);this._finishSort();this._unbindScrollListeners();release._containerDiffX=this._containerDiffX;release._containerDiffY=this._containerDiffY;this._reset();removeClass(element,settings.itemDraggingClass);ItemDrag.autoScroller.removeItem(item);grid._emit(EVENT_DRAG_END,item,event);this._isMigrating?this._finishMigration():release.start()};function openAnchorHref(element){if(element.tagName.toLowerCase()!=="a")return;var href=element.getAttribute("href");if(!href)return;var target=element.getAttribute("target");if(target&&target!=="_self"){window.open(href,target)}else{window.location.href=href}}function getCurrentStyles(element,styles){var result={};var prop,i;if(Array.isArray(styles)){for(i=0;i<styles.length;i++){prop=styles[i];result[prop]=getStyle(element,getStyleName(prop))}}else{for(prop in styles){result[prop]=getStyle(element,getStyleName(prop))}}return result}var unprefixRegEx=/^(webkit|moz|ms|o|Webkit|Moz|MS|O)(?=[A-Z])/;var cache={};function getUnprefixedPropName(prop){var result=cache[prop];if(result)return result;result=prop.replace(unprefixRegEx,"");if(result!==prop){result=result[0].toLowerCase()+result.slice(1)}cache[prop]=result;return result}var nativeCode="[native code]";function isNative(feat){var S=window.Symbol;return!!(feat&&isFunction(S)&&isFunction(S.toString)&&S(feat).toString().indexOf(nativeCode)>-1)}function setStyles(element,styles){for(var prop in styles){element.style[prop]=styles[prop]}}var HAS_WEB_ANIMATIONS=!!(Element&&isFunction(Element.prototype.animate));var HAS_NATIVE_WEB_ANIMATIONS=!!(Element&&isNative(Element.prototype.animate));function Animator(element){this._element=element;this._animation=null;this._duration=0;this._easing="";this._callback=null;this._props=[];this._values=[];this._isDestroyed=false;this._onFinish=this._onFinish.bind(this)}Animator.prototype.start=function(propsFrom,propsTo,options){if(this._isDestroyed)return;var element=this._element;var opts=options||{};if(!HAS_WEB_ANIMATIONS){setStyles(element,propsTo);this._callback=isFunction(opts.onFinish)?opts.onFinish:null;this._onFinish();return}var animation=this._animation;var currentProps=this._props;var currentValues=this._values;var duration=opts.duration||300;var easing=opts.easing||"ease";var cancelAnimation=false;var propName,propCount,propIndex;if(animation){propCount=0;if(duration!==this._duration||easing!==this._easing){cancelAnimation=true}if(!cancelAnimation){for(propName in propsTo){++propCount;propIndex=currentProps.indexOf(propName);if(propIndex===-1||propsTo[propName]!==currentValues[propIndex]){cancelAnimation=true;break}}if(propCount!==currentProps.length){cancelAnimation=true}}}if(cancelAnimation)animation.cancel();this._callback=isFunction(opts.onFinish)?opts.onFinish:null;if(animation&&!cancelAnimation)return;currentProps.length=currentValues.length=0;for(propName in propsTo){currentProps.push(propName);currentValues.push(propsTo[propName])}this._duration=duration;this._easing=easing;this._animation=element.animate([createFrame(propsFrom,HAS_NATIVE_WEB_ANIMATIONS),createFrame(propsTo,HAS_NATIVE_WEB_ANIMATIONS)],{duration:duration,easing:easing});this._animation.onfinish=this._onFinish;setStyles(element,propsTo)};Animator.prototype.stop=function(){if(this._isDestroyed||!this._animation)return;this._animation.cancel();this._animation=this._callback=null;this._props.length=this._values.length=0};Animator.prototype.getCurrentStyles=function(){return getCurrentStyles(element,currentProps)};Animator.prototype.isAnimating=function(){return!!this._animation};Animator.prototype.destroy=function(){if(this._isDestroyed)return;this.stop();this._element=null;this._isDestroyed=true};Animator.prototype._onFinish=function(){var callback=this._callback;this._animation=this._callback=null;this._props.length=this._values.length=0;callback&&callback()};function createFrame(props,prefix){var frame={};for(var prop in props){frame[prefix?prop:getUnprefixedPropName(prop)]=props[prop]}return frame}function getTranslateString(x,y){return"translateX("+x+"px) translateY("+y+"px)"}function ItemDragPlaceholder(item){this._item=item;this._animation=new Animator;this._element=null;this._className="";this._didMigrate=false;this._resetAfterLayout=false;this._left=0;this._top=0;this._transX=0;this._transY=0;this._nextTransX=0;this._nextTransY=0;this._setupAnimation=this._setupAnimation.bind(this);this._startAnimation=this._startAnimation.bind(this);this._updateDimensions=this._updateDimensions.bind(this);this._onLayoutStart=this._onLayoutStart.bind(this);this._onLayoutEnd=this._onLayoutEnd.bind(this);this._onReleaseEnd=this._onReleaseEnd.bind(this);this._onMigrate=this._onMigrate.bind(this);this._onHide=this._onHide.bind(this)}ItemDragPlaceholder.prototype._updateDimensions=function(){if(!this.isActive())return;setStyles(this._element,{width:this._item._width+"px",height:this._item._height+"px"})};ItemDragPlaceholder.prototype._onLayoutStart=function(items,isInstant){var item=this._item;if(items.indexOf(item)===-1){this.reset();return}var nextLeft=item._left;var nextTop=item._top;var currentLeft=this._left;var currentTop=this._top;this._left=nextLeft;this._top=nextTop;if(!isInstant&&!this._didMigrate&&currentLeft===nextLeft&&currentTop===nextTop){return}var nextX=nextLeft+item._marginLeft;var nextY=nextTop+item._marginTop;var grid=item.getGrid();var animEnabled=!isInstant&&grid._settings.layoutDuration>0;if(!animEnabled||this._didMigrate){cancelPlaceholderLayoutTick(item._id);this._element.style[transformProp]=getTranslateString(nextX,nextY);this._animation.stop();if(this._didMigrate){grid.getElement().appendChild(this._element);this._didMigrate=false}return}this._nextTransX=nextX;this._nextTransY=nextY;addPlaceholderLayoutTick(item._id,this._setupAnimation,this._startAnimation)};ItemDragPlaceholder.prototype._setupAnimation=function(){if(!this.isActive())return;var translate=getTranslate(this._element);this._transX=translate.x;this._transY=translate.y};ItemDragPlaceholder.prototype._startAnimation=function(){if(!this.isActive())return;var animation=this._animation;var currentX=this._transX;var currentY=this._transY;var nextX=this._nextTransX;var nextY=this._nextTransY;if(currentX===nextX&&currentY===nextY){if(animation.isAnimating()){this._element.style[transformProp]=getTranslateString(nextX,nextY);animation.stop()}return}var settings=this._item.getGrid()._settings;var currentStyles={};var targetStyles={};currentStyles[transformProp]=getTranslateString(currentX,currentY);targetStyles[transformProp]=getTranslateString(nextX,nextY);animation.start(currentStyles,targetStyles,{duration:settings.layoutDuration,easing:settings.layoutEasing,onFinish:this._onLayoutEnd})};ItemDragPlaceholder.prototype._onLayoutEnd=function(){if(this._resetAfterLayout){this.reset()}};ItemDragPlaceholder.prototype._onReleaseEnd=function(item){if(item._id===this._item._id){if(!this._animation.isAnimating()){this.reset();return}this._resetAfterLayout=true}};ItemDragPlaceholder.prototype._onMigrate=function(data){if(data.item!==this._item)return;var grid=this._item.getGrid();var nextGrid=data.toGrid;grid.off(EVENT_DRAG_RELEASE_END,this._onReleaseEnd);grid.off(EVENT_LAYOUT_START,this._onLayoutStart);grid.off(EVENT_BEFORE_SEND,this._onMigrate);grid.off(EVENT_HIDE_START,this._onHide);nextGrid.on(EVENT_DRAG_RELEASE_END,this._onReleaseEnd);nextGrid.on(EVENT_LAYOUT_START,this._onLayoutStart);nextGrid.on(EVENT_BEFORE_SEND,this._onMigrate);nextGrid.on(EVENT_HIDE_START,this._onHide);this._didMigrate=true};ItemDragPlaceholder.prototype._onHide=function(items){if(items.indexOf(this._item)>-1)this.reset()};ItemDragPlaceholder.prototype.create=function(){if(this.isActive()){this._resetAfterLayout=false;return}var item=this._item;var grid=item.getGrid();var settings=grid._settings;var animation=this._animation;this._left=item._left;this._top=item._top;var element;if(isFunction(settings.dragPlaceholder.createElement)){element=settings.dragPlaceholder.createElement(item)}else{element=document.createElement("div")}this._element=element;animation._element=element;this._className=settings.itemPlaceholderClass||"";if(this._className){addClass(element,this._className)}setStyles(element,{position:"absolute",left:"0px",top:"0px",width:item._width+"px",height:item._height+"px"});element.style[transformProp]=getTranslateString(item._left+item._marginLeft,item._top+item._marginTop);grid.on(EVENT_LAYOUT_START,this._onLayoutStart);grid.on(EVENT_DRAG_RELEASE_END,this._onReleaseEnd);grid.on(EVENT_BEFORE_SEND,this._onMigrate);grid.on(EVENT_HIDE_START,this._onHide);if(isFunction(settings.dragPlaceholder.onCreate)){settings.dragPlaceholder.onCreate(item,element)}grid.getElement().appendChild(element)};ItemDragPlaceholder.prototype.reset=function(){if(!this.isActive())return;var element=this._element;var item=this._item;var grid=item.getGrid();var settings=grid._settings;var animation=this._animation;this._resetAfterLayout=false;cancelPlaceholderLayoutTick(item._id);cancelPlaceholderResizeTick(item._id);animation.stop();animation._element=null;grid.off(EVENT_DRAG_RELEASE_END,this._onReleaseEnd);grid.off(EVENT_LAYOUT_START,this._onLayoutStart);grid.off(EVENT_BEFORE_SEND,this._onMigrate);grid.off(EVENT_HIDE_START,this._onHide);if(this._className){removeClass(element,this._className);this._className=""}element.parentNode.removeChild(element);this._element=null;if(isFunction(settings.dragPlaceholder.onRemove)){settings.dragPlaceholder.onRemove(item,element)}};ItemDragPlaceholder.prototype.isActive=function(){return!!this._element};ItemDragPlaceholder.prototype.getElement=function(){return this._element};ItemDragPlaceholder.prototype.updateDimensions=function(){if(!this.isActive())return;addPlaceholderResizeTick(this._item._id,this._updateDimensions)};ItemDragPlaceholder.prototype.destroy=function(){this.reset();this._animation.destroy();this._item=this._animation=null};function ItemDragRelease(item){this._item=item;this._isActive=false;this._isDestroyed=false;this._isPositioningStarted=false;this._containerDiffX=0;this._containerDiffY=0}ItemDragRelease.prototype.start=function(){if(this._isDestroyed||this._isActive)return;var item=this._item;var grid=item.getGrid();var settings=grid._settings;this._isActive=true;addClass(item._element,settings.itemReleasingClass);if(!settings.dragRelease.useDragContainer){this._placeToGrid()}grid._emit(EVENT_DRAG_RELEASE_START,item);if(!grid._nextLayoutData)item._layout.start(false)};ItemDragRelease.prototype.stop=function(abort,left,top){if(this._isDestroyed||!this._isActive)return;var item=this._item;var grid=item.getGrid();if(!abort&&(left===undefined||top===undefined)){left=item._left;top=item._top}var didReparent=this._placeToGrid(left,top);this._reset(didReparent);if(!abort)grid._emit(EVENT_DRAG_RELEASE_END,item)};ItemDragRelease.prototype.isJustReleased=function(){return this._isActive&&this._isPositioningStarted===false};ItemDragRelease.prototype.destroy=function(){if(this._isDestroyed)return;this.stop(true);this._item=null;this._isDestroyed=true};ItemDragRelease.prototype._placeToGrid=function(left,top){if(this._isDestroyed)return;var item=this._item;var element=item._element;var container=item.getGrid()._element;var didReparent=false;if(element.parentNode!==container){if(left===undefined||top===undefined){var translate=getTranslate(element);left=translate.x-this._containerDiffX;top=translate.y-this._containerDiffY}container.appendChild(element);item._setTranslate(left,top);didReparent=true}this._containerDiffX=0;this._containerDiffY=0;return didReparent};ItemDragRelease.prototype._reset=function(needsReflow){if(this._isDestroyed)return;var item=this._item;var releasingClass=item.getGrid()._settings.itemReleasingClass;this._isActive=false;this._isPositioningStarted=false;this._containerDiffX=0;this._containerDiffY=0;if(releasingClass){if(needsReflow)item._element.clientWidth;removeClass(item._element,releasingClass)}};var MIN_ANIMATION_DISTANCE=2;function ItemLayout(item){var element=item._element;var elementStyle=element.style;this._item=item;this._isActive=false;this._isDestroyed=false;this._isInterrupted=false;this._currentStyles={};this._targetStyles={};this._nextLeft=0;this._nextTop=0;this._offsetLeft=0;this._offsetTop=0;this._skipNextAnimation=false;this._animOptions={onFinish:this._finish.bind(this),duration:0,easing:0};elementStyle.left="0px";elementStyle.top="0px";item._setTranslate(0,0);this._animation=new Animator(element);this._queue="layout-"+item._id;this._setupAnimation=this._setupAnimation.bind(this);this._startAnimation=this._startAnimation.bind(this)}ItemLayout.prototype.start=function(instant,onFinish){if(this._isDestroyed)return;var item=this._item;var release=item._dragRelease;var gridSettings=item.getGrid()._settings;var isPositioning=this._isActive;var isJustReleased=release.isJustReleased();var animDuration=isJustReleased?gridSettings.dragRelease.duration:gridSettings.layoutDuration;var animEasing=isJustReleased?gridSettings.dragRelease.easing:gridSettings.layoutEasing;var animEnabled=!instant&&!this._skipNextAnimation&&animDuration>0;if(isPositioning){cancelLayoutTick(item._id);item._emitter.burst(this._queue,true,item)}if(isJustReleased)release._isPositioningStarted=true;if(isFunction(onFinish)){item._emitter.on(this._queue,onFinish)}this._skipNextAnimation=false;if(!animEnabled){this._updateOffsets();item._setTranslate(this._nextLeft,this._nextTop);this._animation.stop();this._finish();return}if(this._animation.isAnimating()){this._animation._animation.onfinish=null}this._isActive=true;this._animOptions.easing=animEasing;this._animOptions.duration=animDuration;this._isInterrupted=isPositioning;addLayoutTick(item._id,this._setupAnimation,this._startAnimation)};ItemLayout.prototype.stop=function(processCallbackQueue,left,top){if(this._isDestroyed||!this._isActive)return;var item=this._item;cancelLayoutTick(item._id);if(this._animation.isAnimating()){if(left===undefined||top===undefined){var translate=getTranslate(item._element);left=translate.x;top=translate.y}item._setTranslate(left,top);this._animation.stop()}removeClass(item._element,item.getGrid()._settings.itemPositioningClass);this._isActive=false;if(processCallbackQueue){item._emitter.burst(this._queue,true,item)}};ItemLayout.prototype.destroy=function(){if(this._isDestroyed)return;var elementStyle=this._item._element.style;this.stop(true,0,0);this._item._emitter.clear(this._queue);this._animation.destroy();elementStyle[transformProp]="";elementStyle.left="";elementStyle.top="";this._item=null;this._currentStyles=null;this._targetStyles=null;this._animOptions=null;this._isDestroyed=true};ItemLayout.prototype._updateOffsets=function(){if(this._isDestroyed)return;var item=this._item;var migrate=item._migrate;var release=item._dragRelease;this._offsetLeft=release._isActive?release._containerDiffX:migrate._isActive?migrate._containerDiffX:0;this._offsetTop=release._isActive?release._containerDiffY:migrate._isActive?migrate._containerDiffY:0;this._nextLeft=this._item._left+this._offsetLeft;this._nextTop=this._item._top+this._offsetTop};ItemLayout.prototype._finish=function(){if(this._isDestroyed)return;var item=this._item;var migrate=item._migrate;var release=item._dragRelease;item._tX=this._nextLeft;item._tY=this._nextTop;if(this._isActive){this._isActive=false;removeClass(item._element,item.getGrid()._settings.itemPositioningClass)}if(release._isActive)release.stop();if(migrate._isActive)migrate.stop();item._emitter.burst(this._queue,false,item)};ItemLayout.prototype._setupAnimation=function(){var item=this._item;if(item._tX===undefined||item._tY===undefined){var translate=getTranslate(item._element);item._tX=translate.x;item._tY=translate.y}};ItemLayout.prototype._startAnimation=function(){var item=this._item;var settings=item.getGrid()._settings;var isInstant=this._animOptions.duration<=0;this._updateOffsets();var xDiff=Math.abs(item._left-(item._tX-this._offsetLeft));var yDiff=Math.abs(item._top-(item._tY-this._offsetTop));if(isInstant||xDiff<MIN_ANIMATION_DISTANCE&&yDiff<MIN_ANIMATION_DISTANCE){if(xDiff||yDiff||this._isInterrupted){item._setTranslate(this._nextLeft,this._nextTop)}this._animation.stop();this._finish();return}if(!this._isInterrupted){addClass(item._element,settings.itemPositioningClass)}this._currentStyles[transformProp]=getTranslateString(item._tX,item._tY);this._targetStyles[transformProp]=getTranslateString(this._nextLeft,this._nextTop);item._tX=item._tY=undefined;this._animation.start(this._currentStyles,this._targetStyles,this._animOptions)};function ItemMigrate(item){this._item=item;this._isActive=false;this._isDestroyed=false;this._container=false;this._containerDiffX=0;this._containerDiffY=0}ItemMigrate.prototype.start=function(targetGrid,position,container){if(this._isDestroyed)return;var item=this._item;var element=item._element;var isActive=item.isActive();var isVisible=item.isVisible();var grid=item.getGrid();var settings=grid._settings;var targetSettings=targetGrid._settings;var targetElement=targetGrid._element;var targetItems=targetGrid._items;var currentIndex=grid._items.indexOf(item);var targetContainer=container||document.body;var targetIndex;var targetItem;var currentContainer;var offsetDiff;var containerDiff;var translate;var translateX;var translateY;var currentVisClass;var nextVisClass;if(typeof position==="number"){targetIndex=normalizeArrayIndex(targetItems,position,1)}else{targetItem=targetGrid.getItem(position);if(!targetItem)return;targetIndex=targetItems.indexOf(targetItem)}if(item.isPositioning()||this._isActive||item.isReleasing()){translate=getTranslate(element);translateX=translate.x;translateY=translate.y}if(item.isPositioning()){item._layout.stop(true,translateX,translateY)}if(this._isActive){translateX-=this._containerDiffX;translateY-=this._containerDiffY;this.stop(true,translateX,translateY)}if(item.isReleasing()){translateX-=item._dragRelease._containerDiffX;translateY-=item._dragRelease._containerDiffY;item._dragRelease.stop(true,translateX,translateY)}item._visibility.stop(true);if(item._drag)item._drag.destroy();if(grid._hasListeners(EVENT_BEFORE_SEND)){grid._emit(EVENT_BEFORE_SEND,{item:item,fromGrid:grid,fromIndex:currentIndex,toGrid:targetGrid,toIndex:targetIndex})}if(targetGrid._hasListeners(EVENT_BEFORE_RECEIVE)){targetGrid._emit(EVENT_BEFORE_RECEIVE,{item:item,fromGrid:grid,fromIndex:currentIndex,toGrid:targetGrid,toIndex:targetIndex})}if(settings.itemClass!==targetSettings.itemClass){removeClass(element,settings.itemClass);addClass(element,targetSettings.itemClass)}currentVisClass=isVisible?settings.itemVisibleClass:settings.itemHiddenClass;nextVisClass=isVisible?targetSettings.itemVisibleClass:targetSettings.itemHiddenClass;if(currentVisClass!==nextVisClass){removeClass(element,currentVisClass);addClass(element,nextVisClass)}grid._items.splice(currentIndex,1);arrayInsert(targetItems,item,targetIndex);item._gridId=targetGrid._id;if(isActive){currentContainer=element.parentNode;if(targetContainer!==currentContainer){targetContainer.appendChild(element);offsetDiff=getOffsetDiff(targetContainer,currentContainer,true);if(!translate){translate=getTranslate(element);translateX=translate.x;translateY=translate.y}item._setTranslate(translateX+offsetDiff.left,translateY+offsetDiff.top)}}else{targetElement.appendChild(element)}item._visibility.setStyles(isVisible?targetSettings.visibleStyles:targetSettings.hiddenStyles);if(isActive){containerDiff=getOffsetDiff(targetContainer,targetElement,true)}item._refreshDimensions();item._sortData=null;item._drag=targetSettings.dragEnabled?new ItemDrag(item):null;if(isActive){this._isActive=true;this._container=targetContainer;this._containerDiffX=containerDiff.left;this._containerDiffY=containerDiff.top}else{this._isActive=false;this._container=null;this._containerDiffX=0;this._containerDiffY=0}if(grid._hasListeners(EVENT_SEND)){grid._emit(EVENT_SEND,{item:item,fromGrid:grid,fromIndex:currentIndex,toGrid:targetGrid,toIndex:targetIndex})}if(targetGrid._hasListeners(EVENT_RECEIVE)){targetGrid._emit(EVENT_RECEIVE,{item:item,fromGrid:grid,fromIndex:currentIndex,toGrid:targetGrid,toIndex:targetIndex})}};ItemMigrate.prototype.stop=function(abort,left,top){if(this._isDestroyed||!this._isActive)return;var item=this._item;var element=item._element;var grid=item.getGrid();var gridElement=grid._element;var translate;if(this._container!==gridElement){if(left===undefined||top===undefined){if(abort){translate=getTranslate(element);left=translate.x-this._containerDiffX;top=translate.y-this._containerDiffY}else{left=item._left;top=item._top}}gridElement.appendChild(element);item._setTranslate(left,top)}this._isActive=false;this._container=null;this._containerDiffX=0;this._containerDiffY=0};ItemMigrate.prototype.destroy=function(){if(this._isDestroyed)return;this.stop(true);this._item=null;this._isDestroyed=true};function ItemVisibility(item){var isActive=item._isActive;var element=item._element;var childElement=element.children[0];var settings=item.getGrid()._settings;if(!childElement){throw new Error("No valid child element found within item element.")}this._item=item;this._isDestroyed=false;this._isHidden=!isActive;this._isHiding=false;this._isShowing=false;this._childElement=childElement;this._currentStyleProps=[];this._animation=new Animator(childElement);this._queue="visibility-"+item._id;this._finishShow=this._finishShow.bind(this);this._finishHide=this._finishHide.bind(this);element.style.display=isActive?"":"none";addClass(element,isActive?settings.itemVisibleClass:settings.itemHiddenClass);this.setStyles(isActive?settings.visibleStyles:settings.hiddenStyles)}ItemVisibility.prototype.show=function(instant,onFinish){if(this._isDestroyed)return;var item=this._item;var element=item._element;var callback=isFunction(onFinish)?onFinish:null;var grid=item.getGrid();var settings=grid._settings;if(!this._isShowing&&!this._isHidden){callback&&callback(false,item);return}if(this._isShowing&&!instant){callback&&item._emitter.on(this._queue,callback);return}if(!this._isShowing){item._emitter.burst(this._queue,true,item);removeClass(element,settings.itemHiddenClass);addClass(element,settings.itemVisibleClass);if(!this._isHiding)element.style.display=""}callback&&item._emitter.on(this._queue,callback);this._isShowing=true;this._isHiding=this._isHidden=false;this._startAnimation(true,instant,this._finishShow)};ItemVisibility.prototype.hide=function(instant,onFinish){if(this._isDestroyed)return;var item=this._item;var element=item._element;var callback=isFunction(onFinish)?onFinish:null;var grid=item.getGrid();var settings=grid._settings;if(!this._isHiding&&this._isHidden){callback&&callback(false,item);return}if(this._isHiding&&!instant){callback&&item._emitter.on(this._queue,callback);return}if(!this._isHiding){item._emitter.burst(this._queue,true,item);addClass(element,settings.itemHiddenClass);removeClass(element,settings.itemVisibleClass)}callback&&item._emitter.on(this._queue,callback);this._isHidden=this._isHiding=true;this._isShowing=false;this._startAnimation(false,instant,this._finishHide)};ItemVisibility.prototype.stop=function(processCallbackQueue){if(this._isDestroyed)return;if(!this._isHiding&&!this._isShowing)return;var item=this._item;cancelVisibilityTick(item._id);this._animation.stop();if(processCallbackQueue){item._emitter.burst(this._queue,true,item)}};ItemVisibility.prototype.setStyles=function(styles){var childElement=this._childElement;var currentStyleProps=this._currentStyleProps;this._removeCurrentStyles();for(var prop in styles){currentStyleProps.push(prop);childElement.style[prop]=styles[prop]}};ItemVisibility.prototype.destroy=function(){if(this._isDestroyed)return;var item=this._item;var element=item._element;var grid=item.getGrid();var settings=grid._settings;this.stop(true);item._emitter.clear(this._queue);this._animation.destroy();this._removeCurrentStyles();removeClass(element,settings.itemVisibleClass);removeClass(element,settings.itemHiddenClass);element.style.display="";this._isHiding=this._isShowing=false;this._isDestroyed=this._isHidden=true};ItemVisibility.prototype._startAnimation=function(toVisible,instant,onFinish){if(this._isDestroyed)return;var item=this._item;var animation=this._animation;var childElement=this._childElement;var settings=item.getGrid()._settings;var targetStyles=toVisible?settings.visibleStyles:settings.hiddenStyles;var duration=toVisible?settings.showDuration:settings.hideDuration;var easing=toVisible?settings.showEasing:settings.hideEasing;var isInstant=instant||duration<=0;var currentStyles;if(!targetStyles){onFinish&&onFinish();return}cancelVisibilityTick(item._id);if(isInstant){setStyles(childElement,targetStyles);animation.stop();onFinish&&onFinish();return}if(animation.isAnimating()){animation._animation.onfinish=null}addVisibilityTick(item._id,function(){currentStyles=getCurrentStyles(childElement,targetStyles)},function(){animation.start(currentStyles,targetStyles,{duration:duration,easing:easing,onFinish:onFinish})})};ItemVisibility.prototype._finishShow=function(){if(this._isHidden)return;this._isShowing=false;this._item._emitter.burst(this._queue,false,this._item)};ItemVisibility.prototype._finishHide=function(){if(!this._isHidden)return;var item=this._item;this._isHiding=false;item._layout.stop(true,0,0);item._element.style.display="none";item._emitter.burst(this._queue,false,item)};ItemVisibility.prototype._removeCurrentStyles=function(){var childElement=this._childElement;var currentStyleProps=this._currentStyleProps;for(var i=0;i<currentStyleProps.length;i++){childElement.style[currentStyleProps[i]]=""}currentStyleProps.length=0};var id=0;function createUid(){return++id}function Item(grid,element,isActive){var settings=grid._settings;if(ITEM_ELEMENT_MAP){if(ITEM_ELEMENT_MAP.has(element)){throw new Error("You can only create one Muuri Item per element!")}else{ITEM_ELEMENT_MAP.set(element,this)}}this._id=createUid();this._gridId=grid._id;this._element=element;this._isDestroyed=false;this._left=0;this._top=0;this._width=0;this._height=0;this._marginLeft=0;this._marginRight=0;this._marginTop=0;this._marginBottom=0;this._tX=undefined;this._tY=undefined;this._sortData=null;this._emitter=new Emitter;if(element.parentNode!==grid._element){grid._element.appendChild(element)}addClass(element,settings.itemClass);if(typeof isActive!=="boolean"){isActive=getStyle(element,"display")!=="none"}this._isActive=isActive;this._visibility=new ItemVisibility(this);this._layout=new ItemLayout(this);this._migrate=new ItemMigrate(this);this._drag=settings.dragEnabled?new ItemDrag(this):null;this._dragRelease=new ItemDragRelease(this);this._dragPlaceholder=new ItemDragPlaceholder(this)}Item.prototype.getGrid=function(){return GRID_INSTANCES[this._gridId]};Item.prototype.getElement=function(){return this._element};Item.prototype.getWidth=function(){return this._width};Item.prototype.getHeight=function(){return this._height};Item.prototype.getMargin=function(){return{left:this._marginLeft,right:this._marginRight,top:this._marginTop,bottom:this._marginBottom}};Item.prototype.getPosition=function(){return{left:this._left,top:this._top}};Item.prototype.isActive=function(){return this._isActive};Item.prototype.isVisible=function(){return!!this._visibility&&!this._visibility._isHidden};Item.prototype.isShowing=function(){return!!(this._visibility&&this._visibility._isShowing)};Item.prototype.isHiding=function(){return!!(this._visibility&&this._visibility._isHiding)};Item.prototype.isPositioning=function(){return!!(this._layout&&this._layout._isActive)};Item.prototype.isDragging=function(){return!!(this._drag&&this._drag._isActive)};Item.prototype.isReleasing=function(){return!!(this._dragRelease&&this._dragRelease._isActive)};Item.prototype.isDestroyed=function(){return this._isDestroyed};Item.prototype._refreshDimensions=function(force){if(this._isDestroyed)return;if(force!==true&&this._visibility._isHidden)return;var element=this._element;var dragPlaceholder=this._dragPlaceholder;var rect=element.getBoundingClientRect();this._width=rect.width;this._height=rect.height;this._marginLeft=Math.max(0,getStyleAsFloat(element,"margin-left"));this._marginRight=Math.max(0,getStyleAsFloat(element,"margin-right"));this._marginTop=Math.max(0,getStyleAsFloat(element,"margin-top"));this._marginBottom=Math.max(0,getStyleAsFloat(element,"margin-bottom"));if(dragPlaceholder)dragPlaceholder.updateDimensions()};Item.prototype._refreshSortData=function(){if(this._isDestroyed)return;var data=this._sortData={};var getters=this.getGrid()._settings.sortData;var prop;for(prop in getters){data[prop]=getters[prop](this,this._element)}};Item.prototype._addToLayout=function(left,top){if(this._isActive===true)return;this._isActive=true;this._left=left||0;this._top=top||0};Item.prototype._removeFromLayout=function(){if(this._isActive===false)return;this._isActive=false;this._left=0;this._top=0};Item.prototype._canSkipLayout=function(left,top){return this._left===left&&this._top===top&&!this._migrate._isActive&&!this._layout._skipNextAnimation&&!this._dragRelease.isJustReleased()};Item.prototype._setTranslate=function(left,top){if(this._tX===left&&this._tY===top)return false;this._tX=left;this._tY=top;this._element.style[transformProp]=getTranslateString(left,top);return true};Item.prototype._destroy=function(removeElement){if(this._isDestroyed)return;var element=this._element;var grid=this.getGrid();var settings=grid._settings;this._dragPlaceholder.destroy();this._dragRelease.destroy();this._migrate.destroy();this._layout.destroy();this._visibility.destroy();if(this._drag)this._drag.destroy();this._emitter.destroy();removeClass(element,settings.itemClass);if(removeElement)element.parentNode.removeChild(element);if(ITEM_ELEMENT_MAP)ITEM_ELEMENT_MAP.delete(element);this._isActive=false;this._isDestroyed=true};function createPackerProcessor(isWorker){var FILL_GAPS=1;var HORIZONTAL=2;var ALIGN_RIGHT=4;var ALIGN_BOTTOM=8;var ROUNDING=16;var EPS=.001;var MIN_SLOT_SIZE=.5;function roundNumber(number){return((number*1e3+.5<<0)/10<<0)/100}function PackerProcessor(){this.currentRects=[];this.nextRects=[];this.rectTarget={};this.rectStore=[];this.slotSizes=[];this.rectId=0;this.slotIndex=-1;this.slotData={left:0,top:0,width:0,height:0};this.sortRectsLeftTop=this.sortRectsLeftTop.bind(this);this.sortRectsTopLeft=this.sortRectsTopLeft.bind(this)}PackerProcessor.prototype.computeLayout=function(layout,settings){var items=layout.items;var slots=layout.slots;var fillGaps=!!(settings&FILL_GAPS);var horizontal=!!(settings&HORIZONTAL);var alignRight=!!(settings&ALIGN_RIGHT);var alignBottom=!!(settings&ALIGN_BOTTOM);var rounding=!!(settings&ROUNDING);var isPreProcessed=typeof items[0]==="number";var i,bump,item,slotWidth,slotHeight,slot;if(!items.length)return layout;bump=isPreProcessed?2:1;for(i=0;i<items.length;i+=bump){if(isPreProcessed){slotWidth=items[i];slotHeight=items[i+1]}else{item=items[i];slotWidth=item._width+item._marginLeft+item._marginRight;slotHeight=item._height+item._marginTop+item._marginBottom}if(rounding){slotWidth=roundNumber(slotWidth);slotHeight=roundNumber(slotHeight)}slot=this.computeNextSlot(layout,slotWidth,slotHeight,fillGaps,horizontal);if(horizontal){if(slot.left+slot.width>layout.width){layout.width=slot.left+slot.width}}else{if(slot.top+slot.height>layout.height){layout.height=slot.top+slot.height}}slots[++this.slotIndex]=slot.left;slots[++this.slotIndex]=slot.top;if(alignRight||alignBottom){this.slotSizes.push(slot.width,slot.height)}}if(alignRight){for(i=0;i<slots.length;i+=2){slots[i]=layout.width-(slots[i]+this.slotSizes[i])}}if(alignBottom){for(i=1;i<slots.length;i+=2){slots[i]=layout.height-(slots[i]+this.slotSizes[i])}}this.slotSizes.length=0;this.currentRects.length=0;this.nextRects.length=0;this.rectStore.length=0;this.rectId=0;this.slotIndex=-1;return layout};PackerProcessor.prototype.computeNextSlot=function(layout,slotWidth,slotHeight,fillGaps,horizontal){var slot=this.slotData;var currentRects=this.currentRects;var nextRects=this.nextRects;var ignoreCurrentRects=false;var rect;var rectId;var shards;var i;var j;nextRects.length=0;slot.left=null;slot.top=null;slot.width=slotWidth;slot.height=slotHeight;for(i=0;i<currentRects.length;i++){rectId=currentRects[i];if(!rectId)continue;rect=this.getRect(rectId);if(slot.width<=rect.width+EPS&&slot.height<=rect.height+EPS){slot.left=rect.left;slot.top=rect.top;break}}if(slot.left===null){if(horizontal){slot.left=layout.width;slot.top=0}else{slot.left=0;slot.top=layout.height}if(!fillGaps){ignoreCurrentRects=true}}if(!horizontal&&slot.top+slot.height>layout.height+EPS){if(slot.left>MIN_SLOT_SIZE){nextRects.push(this.addRect(0,layout.height,slot.left,Infinity))}if(slot.left+slot.width<layout.width-MIN_SLOT_SIZE){nextRects.push(this.addRect(slot.left+slot.width,layout.height,layout.width-slot.left-slot.width,Infinity))}layout.height=slot.top+slot.height}if(horizontal&&slot.left+slot.width>layout.width+EPS){if(slot.top>MIN_SLOT_SIZE){nextRects.push(this.addRect(layout.width,0,Infinity,slot.top))}if(slot.top+slot.height<layout.height-MIN_SLOT_SIZE){nextRects.push(this.addRect(layout.width,slot.top+slot.height,Infinity,layout.height-slot.top-slot.height))}layout.width=slot.left+slot.width}if(!ignoreCurrentRects){if(fillGaps)i=0;for(;i<currentRects.length;i++){rectId=currentRects[i];if(!rectId)continue;rect=this.getRect(rectId);shards=this.splitRect(rect,slot);for(j=0;j<shards.length;j++){rectId=shards[j];rect=this.getRect(rectId);if(horizontal?rect.left+EPS<layout.width-EPS:rect.top+EPS<layout.height-EPS){nextRects.push(rectId)}}}}if(nextRects.length>1){this.purgeRects(nextRects).sort(horizontal?this.sortRectsLeftTop:this.sortRectsTopLeft)}this.currentRects=nextRects;this.nextRects=currentRects;return slot};PackerProcessor.prototype.addRect=function(left,top,width,height){var rectId=++this.rectId;this.rectStore[rectId]=left||0;this.rectStore[++this.rectId]=top||0;this.rectStore[++this.rectId]=width||0;this.rectStore[++this.rectId]=height||0;return rectId};PackerProcessor.prototype.getRect=function(id,target){if(!target)target=this.rectTarget;target.left=this.rectStore[id]||0;target.top=this.rectStore[++id]||0;target.width=this.rectStore[++id]||0;target.height=this.rectStore[++id]||0;return target};PackerProcessor.prototype.splitRect=function(){var shards=[];var width=0;var height=0;return function(rect,hole){shards.length=0;if(rect.left+rect.width<=hole.left+EPS||hole.left+hole.width<=rect.left+EPS||rect.top+rect.height<=hole.top+EPS||hole.top+hole.height<=rect.top+EPS){shards.push(this.addRect(rect.left,rect.top,rect.width,rect.height));return shards}width=hole.left-rect.left;if(width>=MIN_SLOT_SIZE){shards.push(this.addRect(rect.left,rect.top,width,rect.height))}width=rect.left+rect.width-(hole.left+hole.width);if(width>=MIN_SLOT_SIZE){shards.push(this.addRect(hole.left+hole.width,rect.top,width,rect.height))}height=hole.top-rect.top;if(height>=MIN_SLOT_SIZE){shards.push(this.addRect(rect.left,rect.top,rect.width,height))}height=rect.top+rect.height-(hole.top+hole.height);if(height>=MIN_SLOT_SIZE){shards.push(this.addRect(rect.left,hole.top+hole.height,rect.width,height))}return shards}}();PackerProcessor.prototype.isRectAWithinRectB=function(a,b){return a.left+EPS>=b.left&&a.top+EPS>=b.top&&a.left+a.width-EPS<=b.left+b.width&&a.top+a.height-EPS<=b.top+b.height};PackerProcessor.prototype.purgeRects=function(){var rectA={};var rectB={};return function(rectIds){var i=rectIds.length;var j;while(i--){j=rectIds.length;if(!rectIds[i])continue;this.getRect(rectIds[i],rectA);while(j--){if(!rectIds[j]||i===j)continue;this.getRect(rectIds[j],rectB);if(this.isRectAWithinRectB(rectA,rectB)){rectIds[i]=0;break}}}return rectIds}}();PackerProcessor.prototype.sortRectsTopLeft=function(){var rectA={};var rectB={};return function(aId,bId){this.getRect(aId,rectA);this.getRect(bId,rectB);return rectA.top<rectB.top&&rectA.top+EPS<rectB.top?-1:rectA.top>rectB.top&&rectA.top-EPS>rectB.top?1:rectA.left<rectB.left&&rectA.left+EPS<rectB.left?-1:rectA.left>rectB.left&&rectA.left-EPS>rectB.left?1:0}}();PackerProcessor.prototype.sortRectsLeftTop=function(){var rectA={};var rectB={};return function(aId,bId){this.getRect(aId,rectA);this.getRect(bId,rectB);return rectA.left<rectB.left&&rectA.left+EPS<rectB.left?-1:rectA.left>rectB.left&&rectA.left-EPS<rectB.left?1:rectA.top<rectB.top&&rectA.top+EPS<rectB.top?-1:rectA.top>rectB.top&&rectA.top-EPS>rectB.top?1:0}}();if(isWorker){var PACKET_INDEX_WIDTH=1;var PACKET_INDEX_HEIGHT=2;var PACKET_INDEX_OPTIONS=3;var PACKET_HEADER_SLOTS=4;var processor=new PackerProcessor;self.onmessage=function(msg){var data=new Float32Array(msg.data);var items=data.subarray(PACKET_HEADER_SLOTS,data.length);var slots=new Float32Array(items.length);var settings=data[PACKET_INDEX_OPTIONS];var layout={items:items,slots:slots,width:data[PACKET_INDEX_WIDTH],height:data[PACKET_INDEX_HEIGHT]};processor.computeLayout(layout,settings);data[PACKET_INDEX_WIDTH]=layout.width;data[PACKET_INDEX_HEIGHT]=layout.height;data.set(layout.slots,PACKET_HEADER_SLOTS);postMessage(data.buffer,[data.buffer])}}return PackerProcessor}var PackerProcessor=createPackerProcessor();var blobUrl=null;var activeWorkers=[];function createWorkerProcessors(amount,onmessage){var workers=[];if(amount>0){if(!blobUrl){blobUrl=URL.createObjectURL(new Blob(["("+createPackerProcessor.toString()+")(true)"],{type:"application/javascript"}))}for(var i=0,worker;i<amount;i++){worker=new Worker(blobUrl);if(onmessage)worker.onmessage=onmessage;workers.push(worker);activeWorkers.push(worker)}}return workers}function destroyWorkerProcessors(workers){var worker;var index;for(var i=0;i<workers.length;i++){worker=workers[i];worker.onmessage=null;worker.onerror=null;worker.onmessageerror=null;worker.terminate();index=activeWorkers.indexOf(worker);if(index>-1)activeWorkers.splice(index,1)}if(blobUrl&&!activeWorkers.length){URL.revokeObjectURL(blobUrl);blobUrl=null}}function isWorkerProcessorsSupported(){return!!(window.Worker&&window.URL&&window.Blob)}var FILL_GAPS=1;var HORIZONTAL=2;var ALIGN_RIGHT=4;var ALIGN_BOTTOM=8;var ROUNDING=16;var PACKET_INDEX_ID=0;var PACKET_INDEX_WIDTH=1;var PACKET_INDEX_HEIGHT=2;var PACKET_INDEX_OPTIONS=3;var PACKET_HEADER_SLOTS=4;function Packer(numWorkers,options){this._options=0;this._processor=null;this._layoutQueue=[];this._layouts={};this._layoutCallbacks={};this._layoutWorkers={};this._layoutWorkerData={};this._workers=[];this._onWorkerMessage=this._onWorkerMessage.bind(this);this.setOptions(options);numWorkers=typeof numWorkers==="number"?Math.max(0,numWorkers):0;if(numWorkers&&isWorkerProcessorsSupported()){try{this._workers=createWorkerProcessors(numWorkers,this._onWorkerMessage)}catch(e){this._processor=new PackerProcessor}}else{this._processor=new PackerProcessor}}Packer.prototype._sendToWorker=function(){if(!this._layoutQueue.length||!this._workers.length)return;var layoutId=this._layoutQueue.shift();var worker=this._workers.pop();var data=this._layoutWorkerData[layoutId];delete this._layoutWorkerData[layoutId];this._layoutWorkers[layoutId]=worker;worker.postMessage(data.buffer,[data.buffer])};Packer.prototype._onWorkerMessage=function(msg){var data=new Float32Array(msg.data);var layoutId=data[PACKET_INDEX_ID];var layout=this._layouts[layoutId];var callback=this._layoutCallbacks[layoutId];var worker=this._layoutWorkers[layoutId];if(layout)delete this._layouts[layoutId];if(callback)delete this._layoutCallbacks[layoutId];if(worker)delete this._layoutWorkers[layoutId];if(layout&&callback){layout.width=data[PACKET_INDEX_WIDTH];layout.height=data[PACKET_INDEX_HEIGHT];layout.slots=data.subarray(PACKET_HEADER_SLOTS,data.length);this._finalizeLayout(layout);callback(layout)}if(worker){this._workers.push(worker);this._sendToWorker()}};Packer.prototype._finalizeLayout=function(layout){var grid=layout._grid;var isHorizontal=layout._settings&HORIZONTAL;var isBorderBox=grid._boxSizing==="border-box";delete layout._grid;delete layout._settings;layout.styles={};if(isHorizontal){layout.styles.width=(isBorderBox?layout.width+grid._borderLeft+grid._borderRight:layout.width)+"px"}else{layout.styles.height=(isBorderBox?layout.height+grid._borderTop+grid._borderBottom:layout.height)+"px"}return layout};Packer.prototype.setOptions=function(options){if(!options)return;var fillGaps;if(typeof options.fillGaps==="boolean"){fillGaps=options.fillGaps?FILL_GAPS:0}else{fillGaps=this._options&FILL_GAPS}var horizontal;if(typeof options.horizontal==="boolean"){horizontal=options.horizontal?HORIZONTAL:0}else{horizontal=this._options&HORIZONTAL}var alignRight;if(typeof options.alignRight==="boolean"){alignRight=options.alignRight?ALIGN_RIGHT:0}else{alignRight=this._options&ALIGN_RIGHT}var alignBottom;if(typeof options.alignBottom==="boolean"){alignBottom=options.alignBottom?ALIGN_BOTTOM:0}else{alignBottom=this._options&ALIGN_BOTTOM}var rounding;if(typeof options.rounding==="boolean"){rounding=options.rounding?ROUNDING:0}else{rounding=this._options&ROUNDING}this._options=fillGaps|horizontal|alignRight|alignBottom|rounding};Packer.prototype.createLayout=function(grid,layoutId,items,width,height,callback){if(this._layouts[layoutId]){throw new Error("A layout with the provided id is currently being processed.")}var horizontal=this._options&HORIZONTAL;var layout={id:layoutId,items:items,slots:null,width:horizontal?0:width,height:!horizontal?0:height,_grid:grid,_settings:this._options};if(!items.length){layout.slots=[];this._finalizeLayout(layout);callback(layout);return}if(this._processor){layout.slots=window.Float32Array?new Float32Array(items.length*2):new Array(items.length*2);this._processor.computeLayout(layout,layout._settings);this._finalizeLayout(layout);callback(layout);return}var data=new Float32Array(PACKET_HEADER_SLOTS+items.length*2);data[PACKET_INDEX_ID]=layoutId;data[PACKET_INDEX_WIDTH]=layout.width;data[PACKET_INDEX_HEIGHT]=layout.height;data[PACKET_INDEX_OPTIONS]=layout._settings;var i,j,item;for(i=0,j=PACKET_HEADER_SLOTS-1,item;i<items.length;i++){item=items[i];data[++j]=item._width+item._marginLeft+item._marginRight;data[++j]=item._height+item._marginTop+item._marginBottom}this._layoutQueue.push(layoutId);this._layouts[layoutId]=layout;this._layoutCallbacks[layoutId]=callback;this._layoutWorkerData[layoutId]=data;this._sendToWorker();return this.cancelLayout.bind(this,layoutId)};Packer.prototype.cancelLayout=function(layoutId){var layout=this._layouts[layoutId];if(!layout)return;delete this._layouts[layoutId];delete this._layoutCallbacks[layoutId];if(this._layoutWorkerData[layoutId]){delete this._layoutWorkerData[layoutId];var queueIndex=this._layoutQueue.indexOf(layoutId);if(queueIndex>-1)this._layoutQueue.splice(queueIndex,1)}};Packer.prototype.destroy=function(){for(var key in this._layoutWorkers){this._workers.push(this._layoutWorkers[key])}destroyWorkerProcessors(this._workers);this._workers.length=0;this._layoutQueue.length=0;this._layouts={};this._layoutCallbacks={};this._layoutWorkers={};this._layoutWorkerData={}};var debounceId=0;function debounce(fn,durationMs){var id=++debounceId;var timer=0;var lastTime=0;var isCanceled=false;var tick=function(time){if(isCanceled)return;if(lastTime)timer-=time-lastTime;lastTime=time;if(timer>0){addDebounceTick(id,tick)}else{timer=lastTime=0;fn()}};return function(cancel){if(isCanceled)return;if(durationMs<=0){if(cancel!==true)fn();return}if(cancel===true){isCanceled=true;timer=lastTime=0;tick=undefined;cancelDebounceTick(id);return}if(timer<=0){timer=durationMs;tick(0)}else{timer=durationMs}}}var htmlCollectionType="[object HTMLCollection]";var nodeListType="[object NodeList]";function isNodeList(val){var type=Object.prototype.toString.call(val);return type===htmlCollectionType||type===nodeListType}var objectType="object";var objectToStringType="[object Object]";var toString=Object.prototype.toString;function isPlainObject(val){return typeof val===objectType&&toString.call(val)===objectToStringType}function noop(){}function toArray(val){return isNodeList(val)?Array.prototype.slice.call(val):Array.prototype.concat(val)}var NUMBER_TYPE="number";var STRING_TYPE="string";var INSTANT_LAYOUT="instant";var layoutId=0;function Grid(element,options){if(typeof element===STRING_TYPE){element=document.querySelector(element)}var isElementInDom=element.getRootNode?element.getRootNode({composed:true})===document:document.body.contains(element);if(!isElementInDom||element===document.documentElement){throw new Error("Container element must be an existing DOM element.")}var settings=mergeSettings(Grid.defaultOptions,options);settings.visibleStyles=normalizeStyles(settings.visibleStyles);settings.hiddenStyles=normalizeStyles(settings.hiddenStyles);if(!isFunction(settings.dragSort)){settings.dragSort=!!settings.dragSort}this._id=createUid();this._element=element;this._settings=settings;this._isDestroyed=false;this._items=[];this._layout={id:0,items:[],slots:[]};this._isLayoutFinished=true;this._nextLayoutData=null;this._emitter=new Emitter;this._onLayoutDataReceived=this._onLayoutDataReceived.bind(this);GRID_INSTANCES[this._id]=this;addClass(element,settings.containerClass);bindLayoutOnResize(this,settings.layoutOnResize);this.add(getInitialGridElements(element,settings.items),{layout:false});if(settings.layoutOnInit){this.layout(true)}}Grid.Item=Item;Grid.ItemLayout=ItemLayout;Grid.ItemVisibility=ItemVisibility;Grid.ItemMigrate=ItemMigrate;Grid.ItemDrag=ItemDrag;Grid.ItemDragRelease=ItemDragRelease;Grid.ItemDragPlaceholder=ItemDragPlaceholder;Grid.Emitter=Emitter;Grid.Animator=Animator;Grid.Dragger=Dragger;Grid.Packer=Packer;Grid.AutoScroller=AutoScroller;Grid.defaultPacker=new Packer(2);Grid.defaultOptions={items:"*",showDuration:300,showEasing:"ease",hideDuration:300,hideEasing:"ease",visibleStyles:{opacity:"1",transform:"scale(1)"},hiddenStyles:{opacity:"0",transform:"scale(0.5)"},layout:{fillGaps:false,horizontal:false,alignRight:false,alignBottom:false,rounding:false},layoutOnResize:150,layoutOnInit:true,layoutDuration:300,layoutEasing:"ease",sortData:null,dragEnabled:false,dragContainer:null,dragHandle:null,dragStartPredicate:{distance:0,delay:0},dragAxis:"xy",dragSort:true,dragSortHeuristics:{sortInterval:100,minDragDistance:10,minBounceBackAngle:1},dragSortPredicate:{threshold:50,action:ACTION_MOVE,migrateAction:ACTION_MOVE},dragRelease:{duration:300,easing:"ease",useDragContainer:true},dragCssProps:{touchAction:"none",userSelect:"none",userDrag:"none",tapHighlightColor:"rgba(0, 0, 0, 0)",touchCallout:"none",contentZooming:"none"},dragPlaceholder:{enabled:false,createElement:null,onCreate:null,onRemove:null},dragAutoScroll:{targets:[],handle:null,threshold:50,safeZone:.2,speed:AutoScroller.smoothSpeed(1e3,2e3,2500),sortDuringScroll:true,smoothStop:false,onStart:null,onStop:null},containerClass:"muuri",itemClass:"muuri-item",itemVisibleClass:"muuri-item-shown",itemHiddenClass:"muuri-item-hidden",itemPositioningClass:"muuri-item-positioning",itemDraggingClass:"muuri-item-dragging",itemReleasingClass:"muuri-item-releasing",itemPlaceholderClass:"muuri-item-placeholder"};Grid.prototype.on=function(event,listener){this._emitter.on(event,listener);return this};Grid.prototype.off=function(event,listener){this._emitter.off(event,listener);return this};Grid.prototype.getElement=function(){return this._element};Grid.prototype.getItem=function(target){if(this._isDestroyed||!target&&target!==0){return null}if(typeof target===NUMBER_TYPE){return this._items[target>-1?target:this._items.length+target]||null}if(target instanceof Item){return target._gridId===this._id?target:null}if(ITEM_ELEMENT_MAP){var item=ITEM_ELEMENT_MAP.get(target);return item&&item._gridId===this._id?item:null}else{for(var i=0;i<this._items.length;i++){if(this._items[i]._element===target){return this._items[i]}}}return null};Grid.prototype.getItems=function(targets){if(this._isDestroyed||targets===undefined){return this._items.slice(0)}var items=[];var i,item;if(Array.isArray(targets)||isNodeList(targets)){for(i=0;i<targets.length;i++){item=this.getItem(targets[i]);if(item)items.push(item)}}else{item=this.getItem(targets);if(item)items.push(item)}return items};Grid.prototype.refreshItems=function(items,force){if(this._isDestroyed)return this;var targets=items||this._items;var i,item,style,hiddenItemStyles;if(force===true){hiddenItemStyles=[];for(i=0;i<targets.length;i++){item=targets[i];if(!item.isVisible()&&!item.isHiding()){style=item.getElement().style;style.visibility="hidden";style.display="";hiddenItemStyles.push(style)}}}for(i=0;i<targets.length;i++){targets[i]._refreshDimensions(force)}if(force===true){for(i=0;i<hiddenItemStyles.length;i++){style=hiddenItemStyles[i];style.visibility="";style.display="none"}hiddenItemStyles.length=0}return this};Grid.prototype.refreshSortData=function(items){if(this._isDestroyed)return this;var targets=items||this._items;for(var i=0;i<targets.length;i++){targets[i]._refreshSortData()}return this};Grid.prototype.synchronize=function(){if(this._isDestroyed)return this;var items=this._items;if(!items.length)return this;var fragment;var element;for(var i=0;i<items.length;i++){element=items[i]._element;if(element.parentNode===this._element){fragment=fragment||document.createDocumentFragment();fragment.appendChild(element)}}if(!fragment)return this;this._element.appendChild(fragment);this._emit(EVENT_SYNCHRONIZE);return this};Grid.prototype.layout=function(instant,onFinish){if(this._isDestroyed)return this;var unfinishedLayout=this._nextLayoutData;if(unfinishedLayout&&isFunction(unfinishedLayout.cancel)){unfinishedLayout.cancel()}layoutId=layoutId%MAX_SAFE_FLOAT32_INTEGER+1;var nextLayoutId=layoutId;this._nextLayoutData={id:nextLayoutId,instant:instant,onFinish:onFinish,cancel:null};var items=this._items;var layoutItems=[];for(var i=0;i<items.length;i++){if(items[i]._isActive)layoutItems.push(items[i])}this._refreshDimensions();var gridWidth=this._width-this._borderLeft-this._borderRight;var gridHeight=this._height-this._borderTop-this._borderBottom;var layoutSettings=this._settings.layout;var cancelLayout;if(isFunction(layoutSettings)){cancelLayout=layoutSettings(this,nextLayoutId,layoutItems,gridWidth,gridHeight,this._onLayoutDataReceived)}else{Grid.defaultPacker.setOptions(layoutSettings);cancelLayout=Grid.defaultPacker.createLayout(this,nextLayoutId,layoutItems,gridWidth,gridHeight,this._onLayoutDataReceived)}if(isFunction(cancelLayout)&&this._nextLayoutData&&this._nextLayoutData.id===nextLayoutId){this._nextLayoutData.cancel=cancelLayout}return this};Grid.prototype.add=function(elements,options){if(this._isDestroyed||!elements)return[];var newItems=toArray(elements);if(!newItems.length)return newItems;var opts=options||{};var layout=opts.layout?opts.layout:opts.layout===undefined;var items=this._items;var needsLayout=false;var fragment;var element;var item;var i;for(i=0;i<newItems.length;i++){element=newItems[i];if(element.parentNode!==this._element){fragment=fragment||document.createDocumentFragment();fragment.appendChild(element)}}if(fragment){this._element.appendChild(fragment)}for(i=0;i<newItems.length;i++){element=newItems[i];item=newItems[i]=new Item(this,element,opts.active);if(item._isActive){needsLayout=true;item._layout._skipNextAnimation=true}}for(i=0;i<newItems.length;i++){item=newItems[i];item._refreshDimensions();item._refreshSortData()}arrayInsert(items,newItems,opts.index);if(this._hasListeners(EVENT_ADD)){this._emit(EVENT_ADD,newItems.slice(0))}if(needsLayout&&layout){this.layout(layout===INSTANT_LAYOUT,isFunction(layout)?layout:undefined)}return newItems};Grid.prototype.remove=function(items,options){if(this._isDestroyed||!items.length)return[];var opts=options||{};var layout=opts.layout?opts.layout:opts.layout===undefined;var needsLayout=false;var allItems=this.getItems();var targetItems=[];var indices=[];var index;var item;var i;for(i=0;i<items.length;i++){item=items[i];if(item._isDestroyed)continue;index=this._items.indexOf(item);if(index===-1)continue;if(item._isActive)needsLayout=true;targetItems.push(item);indices.push(allItems.indexOf(item));item._destroy(opts.removeElements);this._items.splice(index,1)}if(this._hasListeners(EVENT_REMOVE)){this._emit(EVENT_REMOVE,targetItems.slice(0),indices)}if(needsLayout&&layout){this.layout(layout===INSTANT_LAYOUT,isFunction(layout)?layout:undefined)}return targetItems};Grid.prototype.show=function(items,options){if(!this._isDestroyed&&items.length){this._setItemsVisibility(items,true,options)}return this};Grid.prototype.hide=function(items,options){if(!this._isDestroyed&&items.length){this._setItemsVisibility(items,false,options)}return this};Grid.prototype.filter=function(predicate,options){if(this._isDestroyed||!this._items.length)return this;var itemsToShow=[];var itemsToHide=[];var isPredicateString=typeof predicate===STRING_TYPE;var isPredicateFn=isFunction(predicate);var opts=options||{};var isInstant=opts.instant===true;var syncWithLayout=opts.syncWithLayout;var layout=opts.layout?opts.layout:opts.layout===undefined;var onFinish=isFunction(opts.onFinish)?opts.onFinish:null;var tryFinishCounter=-1;var tryFinish=noop;var item;var i;if(onFinish){tryFinish=function(){++tryFinishCounter&&onFinish(itemsToShow.slice(0),itemsToHide.slice(0))}}if(isPredicateFn||isPredicateString){for(i=0;i<this._items.length;i++){item=this._items[i];if(isPredicateFn?predicate(item):elementMatches(item._element,predicate)){itemsToShow.push(item)}else{itemsToHide.push(item)}}}if(itemsToShow.length){this.show(itemsToShow,{instant:isInstant,syncWithLayout:syncWithLayout,onFinish:tryFinish,layout:false})}else{tryFinish()}if(itemsToHide.length){this.hide(itemsToHide,{instant:isInstant,syncWithLayout:syncWithLayout,onFinish:tryFinish,layout:false})}else{tryFinish()}if(itemsToShow.length||itemsToHide.length){if(this._hasListeners(EVENT_FILTER)){this._emit(EVENT_FILTER,itemsToShow.slice(0),itemsToHide.slice(0))}if(layout){this.layout(layout===INSTANT_LAYOUT,isFunction(layout)?layout:undefined)}}return this};Grid.prototype.sort=function(){var sortComparer;var isDescending;var origItems;var indexMap;function defaultComparer(a,b){var result=0;var criteriaName;var criteriaOrder;var valA;var valB;for(var i=0;i<sortComparer.length;i++){criteriaName=sortComparer[i][0];criteriaOrder=sortComparer[i][1];valA=(a._sortData?a:a._refreshSortData())._sortData[criteriaName];valB=(b._sortData?b:b._refreshSortData())._sortData[criteriaName];if(criteriaOrder==="desc"||!criteriaOrder&&isDescending){result=valB<valA?-1:valB>valA?1:0}else{result=valA<valB?-1:valA>valB?1:0}if(result)return result}if(!result){if(!indexMap)indexMap=createIndexMap(origItems);result=isDescending?compareIndexMap(indexMap,b,a):compareIndexMap(indexMap,a,b)}return result}function customComparer(a,b){var result=isDescending?-sortComparer(a,b):sortComparer(a,b);if(!result){if(!indexMap)indexMap=createIndexMap(origItems);result=isDescending?compareIndexMap(indexMap,b,a):compareIndexMap(indexMap,a,b)}return result}return function(comparer,options){if(this._isDestroyed||this._items.length<2)return this;var items=this._items;var opts=options||{};var layout=opts.layout?opts.layout:opts.layout===undefined;isDescending=!!opts.descending;origItems=items.slice(0);indexMap=null;if(isFunction(comparer)){sortComparer=comparer;items.sort(customComparer)}else if(typeof comparer===STRING_TYPE){sortComparer=comparer.trim().split(" ").filter(function(val){return val}).map(function(val){return val.split(":")});items.sort(defaultComparer)}else if(Array.isArray(comparer)){items.length=0;items.push.apply(items,comparer)}else{sortComparer=isDescending=origItems=indexMap=null;throw new Error("Invalid comparer argument provided.")}if(this._hasListeners(EVENT_SORT)){this._emit(EVENT_SORT,items.slice(0),origItems)}if(layout){this.layout(layout===INSTANT_LAYOUT,isFunction(layout)?layout:undefined)}sortComparer=isDescending=origItems=indexMap=null;return this}}();Grid.prototype.move=function(item,position,options){if(this._isDestroyed||this._items.length<2)return this;var items=this._items;var opts=options||{};var layout=opts.layout?opts.layout:opts.layout===undefined;var isSwap=opts.action===ACTION_SWAP;var action=isSwap?ACTION_SWAP:ACTION_MOVE;var fromItem=this.getItem(item);var toItem=this.getItem(position);var fromIndex;var toIndex;if(fromItem&&toItem&&fromItem!==toItem){fromIndex=items.indexOf(fromItem);toIndex=items.indexOf(toItem);if(isSwap){arraySwap(items,fromIndex,toIndex)}else{arrayMove(items,fromIndex,toIndex)}if(this._hasListeners(EVENT_MOVE)){this._emit(EVENT_MOVE,{item:fromItem,fromIndex:fromIndex,toIndex:toIndex,action:action})}if(layout){this.layout(layout===INSTANT_LAYOUT,isFunction(layout)?layout:undefined)}}return this};Grid.prototype.send=function(item,targetGrid,position,options){if(this._isDestroyed||targetGrid._isDestroyed||this===targetGrid)return this;item=this.getItem(item);if(!item)return this;var opts=options||{};var container=opts.appendTo||document.body;var layoutSender=opts.layoutSender?opts.layoutSender:opts.layoutSender===undefined;var layoutReceiver=opts.layoutReceiver?opts.layoutReceiver:opts.layoutReceiver===undefined;item._migrate.start(targetGrid,position,container);if(item._migrate._isActive&&item._isActive){if(layoutSender){this.layout(layoutSender===INSTANT_LAYOUT,isFunction(layoutSender)?layoutSender:undefined)}if(layoutReceiver){targetGrid.layout(layoutReceiver===INSTANT_LAYOUT,isFunction(layoutReceiver)?layoutReceiver:undefined)}}return this};Grid.prototype.destroy=function(removeElements){if(this._isDestroyed)return this;var container=this._element;var items=this._items.slice(0);var layoutStyles=this._layout&&this._layout.styles||{};var i,prop;unbindLayoutOnResize(this);for(i=0;i<items.length;i++)items[i]._destroy(removeElements);this._items.length=0;removeClass(container,this._settings.containerClass);for(prop in layoutStyles)container.style[prop]="";this._emit(EVENT_DESTROY);this._emitter.destroy();delete GRID_INSTANCES[this._id];this._isDestroyed=true;return this};Grid.prototype._emit=function(){if(this._isDestroyed)return;this._emitter.emit.apply(this._emitter,arguments)};Grid.prototype._hasListeners=function(event){if(this._isDestroyed)return false;return this._emitter.countListeners(event)>0};Grid.prototype._updateBoundingRect=function(){var element=this._element;var rect=element.getBoundingClientRect();this._width=rect.width;this._height=rect.height;this._left=rect.left;this._top=rect.top;this._right=rect.right;this._bottom=rect.bottom};Grid.prototype._updateBorders=function(left,right,top,bottom){var element=this._element;if(left)this._borderLeft=getStyleAsFloat(element,"border-left-width");if(right)this._borderRight=getStyleAsFloat(element,"border-right-width");if(top)this._borderTop=getStyleAsFloat(element,"border-top-width");if(bottom)this._borderBottom=getStyleAsFloat(element,"border-bottom-width")};Grid.prototype._refreshDimensions=function(){this._updateBoundingRect();this._updateBorders(1,1,1,1);this._boxSizing=getStyle(this._element,"box-sizing")};Grid.prototype._onLayoutDataReceived=function(){var itemsToLayout=[];return function(layout){if(this._isDestroyed||!this._nextLayoutData||this._nextLayoutData.id!==layout.id)return;var grid=this;var instant=this._nextLayoutData.instant;var onFinish=this._nextLayoutData.onFinish;var numItems=layout.items.length;var counter=numItems;var item;var left;var top;var i;this._nextLayoutData=null;if(!this._isLayoutFinished&&this._hasListeners(EVENT_LAYOUT_ABORT)){this._emit(EVENT_LAYOUT_ABORT,this._layout.items.slice(0))}this._layout=layout;itemsToLayout.length=0;for(i=0;i<numItems;i++){item=layout.items[i];if(!item){--counter;continue}left=layout.slots[i*2];top=layout.slots[i*2+1];if(item._canSkipLayout(left,top)){--counter;continue}item._left=left;item._top=top;if(item.isActive()&&!item.isDragging()){itemsToLayout.push(item)}else{--counter}}if(layout.styles){setStyles(this._element,layout.styles)}if(this._hasListeners(EVENT_LAYOUT_START)){this._emit(EVENT_LAYOUT_START,layout.items.slice(0),instant===true);if(this._layout.id!==layout.id)return}var tryFinish=function(){if(--counter>0)return;var hasLayoutChanged=grid._layout.id!==layout.id;var callback=isFunction(instant)?instant:onFinish;if(!hasLayoutChanged){grid._isLayoutFinished=true}if(isFunction(callback)){callback(layout.items.slice(0),hasLayoutChanged)}if(!hasLayoutChanged&&grid._hasListeners(EVENT_LAYOUT_END)){grid._emit(EVENT_LAYOUT_END,layout.items.slice(0))}};if(!itemsToLayout.length){tryFinish();return this}this._isLayoutFinished=false;for(i=0;i<itemsToLayout.length;i++){if(this._layout.id!==layout.id)break;itemsToLayout[i]._layout.start(instant===true,tryFinish)}if(this._layout.id===layout.id){itemsToLayout.length=0}return this}}();Grid.prototype._setItemsVisibility=function(items,toVisible,options){var grid=this;var targetItems=items.slice(0);var opts=options||{};var isInstant=opts.instant===true;var callback=opts.onFinish;var layout=opts.layout?opts.layout:opts.layout===undefined;var counter=targetItems.length;var startEvent=toVisible?EVENT_SHOW_START:EVENT_HIDE_START;var endEvent=toVisible?EVENT_SHOW_END:EVENT_HIDE_END;var method=toVisible?"show":"hide";var needsLayout=false;var completedItems=[];var hiddenItems=[];var item;var i;if(!counter){if(isFunction(callback))callback(targetItems);return}for(i=0;i<targetItems.length;i++){item=targetItems[i];if(toVisible&&!item._isActive||!toVisible&&item._isActive){needsLayout=true}item._layout._skipNextAnimation=!!(toVisible&&!item._isActive);if(toVisible&&item._visibility._isHidden){hiddenItems.push(item)}if(toVisible){item._addToLayout()}else{item._removeFromLayout()}}if(hiddenItems.length){this.refreshItems(hiddenItems,true);hiddenItems.length=0}function triggerVisibilityChange(){if(needsLayout&&opts.syncWithLayout!==false){grid.off(EVENT_LAYOUT_START,triggerVisibilityChange)}if(grid._hasListeners(startEvent)){grid._emit(startEvent,targetItems.slice(0))}for(i=0;i<targetItems.length;i++){if(targetItems[i]._gridId!==grid._id){if(--counter<1){if(isFunction(callback))callback(completedItems.slice(0));if(grid._hasListeners(endEvent))grid._emit(endEvent,completedItems.slice(0))}continue}targetItems[i]._visibility[method](isInstant,function(interrupted,item){if(!interrupted)completedItems.push(item);if(--counter<1){if(isFunction(callback))callback(completedItems.slice(0));if(grid._hasListeners(endEvent))grid._emit(endEvent,completedItems.slice(0))}})}}if(needsLayout&&opts.syncWithLayout!==false){this.on(EVENT_LAYOUT_START,triggerVisibilityChange)}else{triggerVisibilityChange()}if(needsLayout&&layout){this.layout(layout===INSTANT_LAYOUT,isFunction(layout)?layout:undefined)}};function mergeSettings(defaultSettings,userSettings){var settings=mergeObjects({},defaultSettings);if(userSettings){settings=mergeObjects(settings,userSettings)}if(userSettings&&userSettings.visibleStyles){settings.visibleStyles=userSettings.visibleStyles}else if(defaultSettings&&defaultSettings.visibleStyles){settings.visibleStyles=defaultSettings.visibleStyles}if(userSettings&&userSettings.hiddenStyles){settings.hiddenStyles=userSettings.hiddenStyles}else if(defaultSettings&&defaultSettings.hiddenStyles){settings.hiddenStyles=defaultSettings.hiddenStyles}return settings}function mergeObjects(target,source){var sourceKeys=Object.keys(source);var length=sourceKeys.length;var isSourceObject;var propName;var i;for(i=0;i<length;i++){propName=sourceKeys[i];isSourceObject=isPlainObject(source[propName]);if(isPlainObject(target[propName])&&isSourceObject){target[propName]=mergeObjects(mergeObjects({},target[propName]),source[propName]);continue}if(isSourceObject){target[propName]=mergeObjects({},source[propName]);continue}if(Array.isArray(source[propName])){target[propName]=source[propName].slice(0);continue}target[propName]=source[propName]}return target}function getInitialGridElements(gridElement,elements){if(elements==="*"){return gridElement.children}if(typeof elements===STRING_TYPE){var result=[];var children=gridElement.children;for(var i=0;i<children.length;i++){if(elementMatches(children[i],elements)){result.push(children[i])}}return result}if(Array.isArray(elements)||isNodeList(elements)){return elements}return[]}function bindLayoutOnResize(grid,delay){if(typeof delay!==NUMBER_TYPE){delay=delay===true?0:-1}if(delay>=0){grid._resizeHandler=debounce(function(){grid.refreshItems().layout()},delay);window.addEventListener("resize",grid._resizeHandler)}}function unbindLayoutOnResize(grid){if(grid._resizeHandler){grid._resizeHandler(true);window.removeEventListener("resize",grid._resizeHandler);grid._resizeHandler=null}}function normalizeStyles(styles){var normalized={};var docElemStyle=document.documentElement.style;var prop,prefixedProp;for(prop in styles){if(!styles[prop])continue;prefixedProp=getPrefixedPropName(docElemStyle,prop);if(!prefixedProp)continue;normalized[prefixedProp]=styles[prop]}return normalized}function createIndexMap(items){var result={};for(var i=0;i<items.length;i++){result[items[i]._id]=i}return result}function compareIndexMap(indexMap,itemA,itemB){var indexA=indexMap[itemA._id];var indexB=indexMap[itemB._id];return indexA-indexB}return Grid});