<?php
defined( 'ABSPATH' ) || exit;

if ( !class_exists( 'BP_Better_Messages_Calls' ) ):

    class BP_Better_Messages_Calls
    {
        public $audio = false;

        public $video = false;

        public $revertIcons = false;

        public $fastCall    = false;

        public static function instance()
        {
            static $instance = null;

            if ( null === $instance ) {
                $instance = new BP_Better_Messages_Calls();
            }

            return $instance;
        }


        public function __construct()
        {
            $this->audio       = BP_Better_Messages()->settings['audioCalls'] === '1';
            $this->video       = BP_Better_Messages()->settings['videoCalls'] === '1';
            $this->revertIcons = BP_Better_Messages()->settings['callsRevertIcons'] === '1';

            add_action( 'bp_better_messages_thread_pre_header', array( $this, 'call_button' ), 10, 4 );
            add_action( 'bp_messages_thread_main_content',      array( $this, 'html_content' ), 10, 4 );

            add_action( 'wp_ajax_bp_better_messages_record_missed_call',  array( $this, 'record_missed_call' ) );
            add_action( 'wp_ajax_bp_better_messages_record_offline_call', array( $this, 'record_offline_call' ) );

            add_action( 'wp_ajax_bp_better_messages_register_started_call',  array( $this, 'register_started_call' ) );
            add_action( 'wp_ajax_bp_better_messages_register_call_usage',    array( $this, 'register_call_usage' ) );

            if( BP_Better_Messages()->settings['callsLimitFriends'] === '1' ){
                add_filter('bp_better_messages_can_audio_call', array( $this, 'restrict_non_friends_calls'), 10, 3 );
                add_filter('bp_better_messages_can_video_call', array( $this, 'restrict_non_friends_calls'), 10, 3 );
            }

            if( BP_Better_Messages()->settings['profileAudioCall'] === '1' || BP_Better_Messages()->settings['profileVideoCall'] === '1' ) {

                if ( function_exists('bp_get_theme_package_id') && bp_get_theme_package_id() == 'nouveau' ) {
                    add_action('bp_nouveau_get_members_buttons', array($this, 'profile_call_button'), 10, 3);
                } else {
                    add_action( 'bp_member_header_actions', array( $this, 'profile_call_button_legacy' ), 21 );
                }

                #add_action('youzify_social_buttons', array( $this, 'profile_call_button_legacy' ), 10, 1 );

                add_action( 'template_redirect', array($this, 'catch_fast_call') );
            }

            add_action( 'wp_ajax_bp_better_messages_get_thread_group_call_access_key',    array( $this, 'get_thread_group_call_access_key' ) );
            add_action( 'wp_ajax_bp_better_messages_thread_group_call_admin',    array( $this, 'thread_group_call_admin' ) );
            add_action( 'bp_better_messages_pinned_message',    array( $this, 'pinned_message' ), 10, 4 );


            /**
             * Grimlock profile call button
             */
            if( defined('GRIMLOCK_BUDDYPRESS_VERSION') ) {
                add_action('bp_member_header_actions', array($this, 'grimlock_profile_call_button'), 20);
            }

            if( defined('YOUZIFY_VERSION') ) {
                add_action('youzify_social_buttons', array($this, 'youzify_profile_call_button'), 20, 1);
            }

            add_filter('bp_nouveau_customizer_user_profile_actions', array($this, 'bp_nouveau_customizer_user_profile_actions'), 20, 1 );
        }

        public function bp_nouveau_customizer_user_profile_actions($buttons){
            $buttons['bpbm_audio_call'] = __( 'Audio Call', 'bp-better-messages' );
            $buttons['bpbm_video_call'] = __( 'Video Call', 'bp-better-messages' );
            return $buttons;
        }

        public function youzify_profile_call_button( $user_id ){

            $can_call = true;

            if( BP_Better_Messages()->settings['callsLimitFriends'] === '1' ){
                if( function_exists( 'friends_check_friendship' ) ){

                    if( current_user_can('manage_options') ){
                        /*
                         * Admin always can call
                         */
                        $can_call = true;
                    } else {
                        $can_call = friends_check_friendship(get_current_user_id(), $user_id);
                    }
                }
            }

            if( ! $can_call ){
                return false;
            }

            $base_link = BP_Better_Messages()->functions->get_link( get_current_user_id() );


            if( $this->audio && BP_Better_Messages()->settings['profileAudioCall'] === '1' ){
                $link = add_query_arg([
                    'fast-call' => '',
                    'to' => $user_id,
                    'type' => 'audio'
                ], $base_link);


                echo '<div class="bpbm-youzify-btn generic-button" id="bpbm-audio-call"><a href="' . $link . '" data-user-id="' . $user_id .'" class="audio-call grimlock-btn bpbm-audio-call"><i class="fas fa-phone"></i>' . __( 'Audio Call', 'bp-better-messages' ) . '</a></div>';
            }


            if( $this->video && BP_Better_Messages()->settings['profileVideoCall'] === '1' ) {
                $link = add_query_arg([
                    'fast-call' => '',
                    'to' => $user_id,
                    'type' => 'video'
                ], $base_link);

                echo '<div class="bpbm-youzify-btn generic-button" id="bpbm-video-call"><a href="' . $link . '" data-user-id="' . $user_id .'" class="video-call grimlock-btn bpbm-video-call"><i class="fas fa-video"></i>' . __( 'Video Call', 'bp-better-messages' ) . '</a></div>';

            }

        }

        public function grimlock_profile_call_button(){

            $can_call = true;

            $user_id = bp_displayed_user_id();
            if( BP_Better_Messages()->settings['callsLimitFriends'] === '1' ){
                if( function_exists( 'friends_check_friendship' ) ){

                    if( current_user_can('manage_options') ){
                        /*
                         * Admin always can call
                         */
                        $can_call = true;
                    } else {
                        $can_call = friends_check_friendship(get_current_user_id(), $user_id);
                    }
                }
            }

            if( ! $can_call ){
                return false;
            }

            $base_link = BP_Better_Messages()->functions->get_link( get_current_user_id() );


            if( $this->audio && BP_Better_Messages()->settings['profileAudioCall'] === '1' ){
                $link = add_query_arg([
                    'fast-call' => '',
                    'to' => $user_id,
                    'type' => 'audio'
                ], $base_link);


                echo '<div class="generic-button" id="bpbm-audio-call"><a href="' . $link . '" data-user-id="' . $user_id .'" class="audio-call grimlock-btn bpbm-audio-call">' . __( 'Audio Call', 'bp-better-messages' ) . '</a></div>';
            }


            if( $this->video && BP_Better_Messages()->settings['profileVideoCall'] === '1' ) {
                $link = add_query_arg([
                    'fast-call' => '',
                    'to' => $user_id,
                    'type' => 'video'
                ], $base_link);

                echo '<div class="generic-button" id="bpbm-video-call"><a href="' . $link . '" data-user-id="' . $user_id .'" class="video-call grimlock-btn bpbm-video-call">' . __( 'Video Call', 'bp-better-messages' ) . '</a></div>';

            }

        }


        public function catch_fast_call(){
            if( isset($_GET['fast-call'])
                && isset($_GET['to'])
                && isset($_GET['type'])
                && ! empty($_GET['to'])
                && ! empty($_GET['type'])
                && (rtrim(str_replace($_SERVER['QUERY_STRING'], '', $_SERVER['REQUEST_URI']), '?') === str_replace(site_url(''), '', BP_Better_Messages()->functions->get_link()))
            ){
                $type = $_GET['type'];

                if( $type !== 'audio' && $type !== 'video' ){
                    return false;
                }

                $to = get_userdata(intval($_GET['to']));
                if( ! $to ) return false;

                $thread_id = BP_Better_Messages()->functions->get_pm_thread_id($to->ID);

                $url = add_query_arg([
                    'thread_id' => $thread_id
                ], BP_Better_Messages()->functions->get_link() );

                if( $type === 'audio' ){
                    $url .= '&audioCall';
                }

                if( $type === 'video' ){
                    $url .= '&videoCall';
                }

                wp_redirect($url);
                exit;
            }
        }

        public function profile_call_button_legacy(){
            if ( bp_is_my_profile() || ! is_user_logged_in() ) {
                return false;
            }

            $user_id = bp_displayed_user_id();

            $can_call = true;

            if( BP_Better_Messages()->settings['callsLimitFriends'] === '1' ){
                if( function_exists( 'friends_check_friendship' ) ){
                    if( current_user_can('manage_options') ){
                        /*
                         * Admin always can call
                         */
                        $can_call = true;
                    } else {
                        $can_call = friends_check_friendship(get_current_user_id(), $user_id);
                    }
                }
            }


            if( ! $can_call ) {
                return false;
            }

            $base_link = BP_Better_Messages()->functions->get_link( get_current_user_id() );


            if( $this->audio && BP_Better_Messages()->settings['profileAudioCall'] === '1' ) {
                $link = add_query_arg([
                    'fast-call' => '',
                    'to' => $user_id,
                    'type' => 'audio'
                ], $base_link);
                echo bp_get_button(array(
                    'id' => 'bpbm_audio_call',
                    'component' => 'messages',
                    'must_be_logged_in' => true,
                    'block_self' => true,
                    'wrapper_id' => 'bpbm-audio-call',
                    'link_href' => $link,
                    'link_text' => __('Audio Call', 'bp-better-messages'),
                    'link_class' => 'bpbm-audio-call',
                    'button_attr' => [
                        'data-user-id' => $user_id
                    ]
                ));
            }

            if( $this->video && BP_Better_Messages()->settings['profileVideoCall'] === '1' ) {
                $link = add_query_arg([
                    'fast-call' => '',
                    'to' => $user_id,
                    'type' => 'video'
                ], $base_link);
                echo bp_get_button(array(
                    'id' => 'bpbm_video_call',
                    'component' => 'messages',
                    'must_be_logged_in' => true,
                    'block_self' => true,
                    'wrapper_id' => 'bpbm-video-call',
                    'link_href' => $link,
                    'link_text' => __('Video Call', 'bp-better-messages'),
                    'link_class' => 'bpbm-video-call',
                    'button_attr' => [
                        'data-user-id' => $user_id
                    ]
                ));
            }

        }

        public function profile_call_button( $buttons, $user_id, $type ){

            if ( ! is_user_logged_in() ) {
                return $buttons;
            }

            if( $type === 'profile' ){
                $can_call = true;

                if( BP_Better_Messages()->settings['callsLimitFriends'] === '1' ){
                    if( function_exists( 'friends_check_friendship' ) ){

                        if( current_user_can('manage_options') ){
                            /*
                             * Admin always can call
                             */
                            $can_call = true;
                        } else {
                            $can_call = friends_check_friendship(get_current_user_id(), $user_id);
                        }
                    }
                }

                if( ! $can_call ){
                    return $buttons;
                }

                $base_link = BP_Better_Messages()->functions->get_link( get_current_user_id() );

                $tag = 'li';

                if( defined('BP_PLATFORM_VERSION') ){
                    $tag = 'div';
                }

                if( $this->audio && BP_Better_Messages()->settings['profileAudioCall'] === '1' ){
                    $link = add_query_arg([
                        'fast-call' => '',
                        'to' => $user_id,
                        'type' => 'audio'
                    ], $base_link);

                    $buttons['audio_call'] = array(
                        'id'                => 'bpbm_audio_call',
                        'component'         => 'messages',
                        'must_be_logged_in' => true,
                        'block_self'        => true,
                        'parent_element'    => $tag,
                        'wrapper_id'        => 'bpbm-audio-call',
                        'link_href'         => $link,
                        'link_text'         => __( 'Audio Call', 'bp-better-messages' ),
                        'link_class'        => 'bpbm-audio-call',
                        'button_attr'       => [
                            'data-user-id' => $user_id
                        ]
                    );
                }


                if( $this->video && BP_Better_Messages()->settings['profileVideoCall'] === '1' ) {
                    $link = add_query_arg([
                        'fast-call' => '',
                        'to' => $user_id,
                        'type' => 'video'
                    ], $base_link);

                    $buttons['video_call'] = array(
                        'id' => 'bpbm_video_call',
                        'component' => 'messages',
                        'must_be_logged_in' => true,
                        'block_self' => true,
                        'parent_element' => $tag,
                        'wrapper_id' => 'bpbm-video-call',
                        'link_href' => $link,
                        'link_text' => __('Video Call', 'bp-better-messages'),
                        'link_class' => 'bpbm-video-call',
                        'button_attr' => [
                            'data-user-id' => $user_id
                        ]
                    );
                }
            }

            return $buttons;

        }

        public function restrict_non_friends_calls( $can_call, $user_id, $thread_id ){
            if( ! function_exists( 'friends_check_friendship' ) ) return $can_call;

            $participants = BP_Better_Messages()->functions->get_participants($thread_id);
            if(count($participants['users']) !== 2) return false;

            unset($participants['users'][$user_id]);
            reset($participants['users']);

            $friend_id = key($participants['users']);

            /**
             * Allow users reply to calls even if not friends
             */
            if( current_user_can('manage_options') || user_can( $friend_id, 'manage_options' ) ) {
                return $can_call;
            }

            return friends_check_friendship($user_id, $friend_id);
        }

        public function can_audio_call_in_thread( $thread_id, $user_id ){
            $can_send_message = apply_filters('bp_better_messages_can_send_message', BP_Messages_Thread::check_access( $thread_id ), $user_id, $thread_id );
            $can_send_message = apply_filters('bp_better_messages_can_start_call', $can_send_message, $user_id, $thread_id );
            if( ! $can_send_message  ) return false;

            return apply_filters('bp_better_messages_can_audio_call', $can_send_message, $user_id, $thread_id );
        }

        public function can_video_call_in_thread( $thread_id, $user_id ){
            $can_send_message = apply_filters('bp_better_messages_can_send_message', BP_Messages_Thread::check_access( $thread_id ), $user_id, $thread_id );
            $can_send_message = apply_filters('bp_better_messages_can_start_call', $can_send_message, $user_id, $thread_id );
            if( ! $can_send_message  ) return false;

            return apply_filters('bp_better_messages_can_video_call', $can_send_message, $user_id, $thread_id );
        }

        public function register_started_call()
        {
            global $call_data;

            $user_id = get_current_user_id();
            $thread_id = intval($_REQUEST['thread_id']);
            $type = sanitize_text_field($_REQUEST['type']);
            $duration   = 0;

            $mins       = floor($duration / 60 % 60);
            $secs       = floor($duration % 60);
            $seconds    = sprintf('%02d:%02d', $mins, $secs);

            $call_data = [
                'caller_id'    => $user_id,
                'thread_id'    => $thread_id,
                'type'         => $type,
                'call_started' => bp_core_current_time(),
                'mins'      => $mins,
                'secs'      => $secs,
                'duration'  => $seconds,
            ];

            $can_send_message = apply_filters('bp_better_messages_can_send_message', BP_Messages_Thread::check_access( $thread_id ), $user_id, $thread_id );
            if( ! apply_filters('bp_better_messages_can_start_call', $can_send_message, $user_id, $thread_id ) ) return false;

            if( $type === 'audio' ){
                $can_audio_call = $this->can_audio_call_in_thread( $thread_id, $user_id );

                if( ! $can_audio_call ) return false;
                $message = '<span class="bpbm-call bpbm-call-audio call-accepted">' . sprintf( __( 'Audio call accepted <span class="bpbm-call-duration">(%s)</span>', 'bp-better-messages' ), $seconds )  . '</span>';

                $args = array(
                    'sender_id'   => $user_id,
                    'thread_id'   => $thread_id,
                    'content'     => $message,
                    'date_sent'  => bp_core_current_time()
                );

                add_action( 'messages_message_sent', array( $this, 'record_call_data' ), 5 );
                messages_new_message( $args );
                remove_action( 'messages_message_sent', array( $this, 'record_call_data' ), 5 );
            }


            if( $type === 'video' ){
                $can_video_call = $this->can_video_call_in_thread( $thread_id, $user_id );

                if( ! $can_video_call ) return false;
                $message = '<span class="bpbm-call bpbm-call-video call-accepted">' . sprintf( __( 'Video call accepted <span class="bpbm-call-duration">(%s)</span>', 'bp-better-messages' ), $seconds ) . '</span>';

                $args = array(
                    'sender_id'   => $user_id,
                    'thread_id'   => $thread_id,
                    'content'     => $message,
                    'date_sent'   => bp_core_current_time()
                );

                add_action( 'messages_message_sent', array( $this, 'record_call_data' ), 5 );
                messages_new_message( $args );
                remove_action( 'messages_message_sent', array( $this, 'record_call_data' ),5 );
            }

            wp_send_json( $call_data['message_id'] );

        }

        public function register_call_usage(){
            global $call_data;

            $user_id    = get_current_user_id();
            $message_id = intval( $_REQUEST['call_message_id'] );
            $message    = new BP_Messages_Message( $message_id );

            $duration   = intval( $_REQUEST['duration'] );

            $mins       = floor($duration / 60 % 60);
            $secs       = floor($duration % 60);
            $seconds    = sprintf('%02d:%02d', $mins, $secs);

            $call_data = [
                'mins'      => $mins,
                'secs'      => $secs,
                'duration'  => $seconds,
            ];

            if( $user_id !== $message->sender_id ) return false;

            $type = bp_messages_get_meta( $message_id, 'type', true );
            if( $type === 'video' ){
                $message->message    = apply_filters( 'messages_message_content_before_save', '<span class="bpbm-call bpbm-call-video call-accepted">' . sprintf( __( 'Video call accepted <span class="bpbm-call-duration">(%s)</span>', 'bp-better-messages' ), $seconds ) . '</span>', $message_id);
            } else if( $type === 'audio' ){
                $message->message    = apply_filters( 'messages_message_content_before_save', '<span class="bpbm-call bpbm-call-audio call-accepted">' . sprintf( __( 'Audio call accepted <span class="bpbm-call-duration">(%s)</span>', 'bp-better-messages' ), $seconds ) . '</span>', $message_id);
            } else {
                exit;
            }

            foreach( $call_data as $key => $value ){
                bp_messages_update_meta( $message_id, $key, sanitize_text_field( $value ) );
            }

            $message->recipients = $message->get_recipients();

            global $wpdb;

            $wpdb->update(bpbm_get_table('messages'), [
                'message' => $message->message
            ], [
                'id' => $message_id
            ]);

            $message->count_unread = false;

            BP_Better_Messages_Premium()->on_message_sent( $message );

            exit;
        }

        public function record_call_data( &$message ){
            global $call_data;

            $message_id = $message->id;

            bp_messages_update_meta( $message_id, 'bpbm_call', true );
            bp_messages_update_meta( $message_id, 'bpbm_call_accepted', true );
            foreach( $call_data as $key => $value ){
                bp_messages_update_meta( $message_id, $key, sanitize_text_field( $value ) );
            }

            $call_data['message_id'] = $message_id;
            $message->count_unread = false;
        }

        public function record_offline_call(){
            global $call_data;

            $user_id   = get_current_user_id();
            $thread_id = intval( $_REQUEST['thread_id'] );
            $type      = sanitize_text_field( $_REQUEST['type'] );

            $call_data = [
                'caller_id' => $user_id,
                'thread_id' => $thread_id,
                'type'      => $type,
            ];

            $can_send_message = apply_filters('bp_better_messages_can_send_message', BP_Messages_Thread::check_access( $thread_id ), $user_id, $thread_id );
            if( ! $can_send_message  ) return false;

            if( $type === 'audio' ){
                $can_audio_call = $this->can_audio_call_in_thread($thread_id, $user_id);

                if( ! $can_audio_call ) return false;
                $message = '<span class="bpbm-call bpbm-call-audio missed missed-offline">' . __( 'I tried to make audio call, but you were offline', 'bp-better-messages' )  . '</span>';

                $args = array(
                    'sender_id'   => $user_id,
                    'thread_id'   => $thread_id,
                    'content'     => $message,
                    'date_sent'  => bp_core_current_time()
                );

                add_action( 'messages_message_sent', array( $this, 'record_missed_call_data' ) );
                messages_new_message( $args );
                remove_action( 'messages_message_sent', array( $this, 'record_missed_call_data' ) );
            }


            if( $type === 'video' ){
                $can_video_call = $this->can_video_call_in_thread($thread_id, $user_id);

                if( ! $can_video_call ) return false;
                $message = '<span class="bpbm-call bpbm-call-video missed missed-offline">' . __( 'I tried to make video call, but you were offline', 'bp-better-messages' ) . '</span>';

                $args = array(
                    'sender_id'   => $user_id,
                    'thread_id'   => $thread_id,
                    'content'     => $message,
                    'date_sent'   => bp_core_current_time()
                );

                add_action( 'messages_message_sent', array( $this, 'record_missed_call_data' ) );
                messages_new_message( $args );
                remove_action( 'messages_message_sent', array( $this, 'record_missed_call_data' ) );
            }

            exit;
        }

        public function record_missed_call(){
            global $call_data;

            $user_id   = get_current_user_id();
            $thread_id = intval( $_REQUEST['thread_id'] );
            $type      = sanitize_text_field( $_REQUEST['type'] );
            $duration  = intval( $_REQUEST['duration'] );

            $mins    = floor($duration / 60 % 60);
            $secs    = floor($duration % 60);
            $seconds = sprintf('%02d:%02d', $mins, $secs);

            $call_data = [
                'caller_id' => $user_id,
                'thread_id' => $thread_id,
                'type'      => $type,
                'mins'      => $mins,
                'secs'      => $secs,
                'duration'  => $seconds,
            ];

            if( $type === 'audio' ){
                $can_audio_call = $this->can_audio_call_in_thread( $thread_id, $user_id );

                if( ! $can_audio_call ) return false;
                $message = '<span class="bpbm-call bpbm-call-audio missed">' . sprintf( __( 'Missed audio call <span class="bpbm-call-duration">(%s)</span>', 'bp-better-messages' ), $seconds ) . '</span>';

                $args = array(
                    'sender_id'   => $user_id,
                    'thread_id'   => $thread_id,
                    'content'     => $message,
                    'date_sent'  => bp_core_current_time()
                );

                add_action( 'messages_message_sent', array( $this, 'record_missed_call_data' ) );
                messages_new_message( $args );
                remove_action( 'messages_message_sent', array( $this, 'record_missed_call_data' ) );
            }


            if( $type === 'video' ){
                $can_video_call = $this->can_video_call_in_thread( $thread_id, $user_id );

                if( ! $can_video_call ) return false;
                $message = '<span class="bpbm-call bpbm-call-video missed">' . sprintf( __( 'Missed video call <span class="bpbm-call-duration">(%s)</span>', 'bp-better-messages' ), $seconds ) . '</span>';

                $args = array(
                    'sender_id'   => $user_id,
                    'thread_id'   => $thread_id,
                    'content'     => $message,
                    'date_sent'   => bp_core_current_time()
                );

                add_action( 'messages_message_sent', array( $this, 'record_missed_call_data' ) );
                messages_new_message( $args );
                remove_action( 'messages_message_sent', array( $this, 'record_missed_call_data' ) );
            }

            exit;
        }

        public function record_missed_call_data( $message ){
            global $call_data;

            $message_id = $message->id;

            bp_messages_add_meta( $message_id, 'bpbm_call', true );
            bp_messages_add_meta( $message_id, 'bpbm_missed_call', true );
            foreach( $call_data as $key => $value ){
                bp_messages_add_meta( $message_id, $key, sanitize_text_field( $value ) );
            }
        }

        public function is_group_call_active( $thread_type, $participants_count ){
            $groupsCallActive = false;

            if( $thread_type === 'thread' && $participants_count > 2 ){
                $groupsCallActive = BP_Better_Messages()->settings['groupCallsThreads'] === '1';
            }
            if( $thread_type === 'chat-room' ){
                $groupsCallActive = BP_Better_Messages()->settings['groupCallsChats'] === '1';
            }
            if( $thread_type === 'group' ){
                $groupsCallActive = BP_Better_Messages()->settings['groupCallsGroups'] === '1';
            }

            return $groupsCallActive;
        }

        public function call_button( $thread_id, $participants, $is_mini, $type = 'thread' ){
            #if( $type !== 'thread' ) return false;
            if( ! BP_Better_Messages()->functions->can_use_premium_code() ) return false;
            # if( ! bpbm_fs()->can_use_premium_code() ) return false;
            $can_send_message = apply_filters('bp_better_messages_can_send_message', BP_Messages_Thread::check_access( $thread_id ), get_current_user_id(), $thread_id );
            if( ! apply_filters('bp_better_messages_can_start_call', $can_send_message, get_current_user_id(), $thread_id ) ) return false;

            $can_video_call = $this->can_video_call_in_thread( $thread_id, get_current_user_id() );
            $can_audio_call = $this->can_audio_call_in_thread( $thread_id, get_current_user_id() );

            $groupsCallActive = $this->is_group_call_active( $type, $participants['count']  );

            $participants_count = count( $participants['recipients'] );
            if( $participants_count === 1 && $type === 'thread' ){
                if( $this->video && $can_video_call ){
                    if( $is_mini ){
                        if( BP_Better_Messages()->settings['miniChatVideoCall'] === '1' ) {
                            echo '<span class="video-call" data-user-id="' . $participants["recipients"][0] . '"></span>';
                        }
                    } else {
                        echo '<a href="#" class="video-call bpbm-can-be-hidden" data-user-id="' . $participants[ "recipients" ][0] . '"  title="' . __("Video Call", "bp-better-messages") . '"><i class="fas fa-video"></i></a>';
                    }
                }

                if( $this->audio && $can_audio_call ) {
                    if ($is_mini) {
                        if( BP_Better_Messages()->settings['miniChatAudioCall'] === '1' ) {
                            echo '<span class="audio-call" data-user-id="' . $participants["recipients"][0] . '"></span>';
                        }
                    } else {
                        echo '<a href="#" class="audio-call bpbm-can-be-hidden" data-user-id="' . $participants["recipients"][0] . '"  title="' . __("Audio Call", "bp-better-messages") . '"><i class="fas fa-phone"></i></a>';
                    }
                }
            } else if( $groupsCallActive ){
                echo '<a href="#" class="group-call bpbm-can-be-hidden" data-thread-id="' . $thread_id . '"  title="' . __("Video Chat", "bp-better-messages") . '"><i class="fas fa-video"></i></a>';
            }
        }

        public function pinned_message( $thread_id, $participants, $is_mini, $type = 'thread' ){
            $groupsCallActive = $this->is_group_call_active( $type, $participants['count']  );
            if( ! $groupsCallActive ) return false;
            ?><div class="bpbm-group-call-in-progress" style="display: none">
            <span class="bpbm-group-call-in-progress-info">
                    <i class="fas fa-users"></i> <span class="bpbm-group-call-participant-count">1</span> <?php _e('participants are in group call', 'bp-better-messages'); ?>
                </span>
            <span class="bpbm-group-call-in-progress-join">
                    <button><?php _e('Join Group Call', 'bp-better-messages'); ?></button>
                </span>
            </div>
            <?php
        }

        public function html_content( $thread_id, $participants, $is_mini, $type ){
            if( $is_mini ) return false;

            $can_send_message = apply_filters('bp_better_messages_can_send_message', BP_Messages_Thread::check_access( $thread_id ), get_current_user_id(), $thread_id );
            if( ! apply_filters('bp_better_messages_can_start_call', $can_send_message, get_current_user_id(), $thread_id ) ) return false;

            $disable_mic_icon = 'fas fa-microphone-slash';
            $enable_mic_icon  = 'fas fa-microphone';

            $disable_video_icon = 'fas fa-video-slash';
            $enable_video_icon  = 'fas fa-video';

            if( $this->revertIcons ){
                $disable_mic_icon = 'fas fa-microphone';
                $enable_mic_icon  = 'fas fa-microphone-slash';

                $disable_video_icon = 'fas fa-video';
                $enable_video_icon  = 'fas fa-video-slash';
            }

            $groupsCallActive = $this->is_group_call_active( $type, $participants['count'] );

            ob_start();

            $isGroupCall = false;

            if( $groupsCallActive ){ $isGroupCall = true; ?>
                <div class="bp-messages-group-call-container bp-messages-call-container">
                    <div class="bp-messages-group-call-videos-grid">
                    </div>

                    <div class="bp-messages-group-call-controls" style="display: none">
                        <div class="bpbm-call-settings" style="display: none">
                            <div class="bpbm-call-setting bpbm-switch-camera">
                                <label><?php _e('Camera', 'bp-better-messages'); ?></label>
                                <div class="bpbm-switch-camera-select-wrap"></div>
                            </div>
                            <div class="bpbm-call-setting bpbm-switch-audio">
                                <label><?php _e('Speaker', 'bp-better-messages'); ?></label>
                                <div class="bpbm-switch-audio-select-wrap"></div>
                            </div>
                            <div class="bpbm-call-setting bpbm-switch-mic">
                                <label><?php _e('Microphone', 'bp-better-messages'); ?></label>
                                <div class="bpbm-switch-mic-select-wrap"></div>
                            </div>
                        </div>
                        <div class="bpbm-call-in-progress">

                            <span class="bpbm-configure-call" style="display:none" title="<?php _e('Configure', 'bp-better-messages'); ?>"><i class="fas fa-cog"></i></span>

                            <span class="bpbm-disable-video" title="<?php _e('Disable Video', 'bp-better-messages'); ?>" style="display: none"><i class="<?php echo $disable_video_icon; ?>"></i></span>
                            <span class="bpbm-enable-video" title="<?php _e('Enable Video', 'bp-better-messages'); ?>"><i class="<?php echo $enable_video_icon; ?>"></i></span>

                            <span class="bpbm-disable-mic" title="<?php _e('Disable Microphone', 'bp-better-messages'); ?>" style="display: none"><i class="<?php echo $disable_mic_icon; ?>"></i></span>
                            <span class="bpbm-enable-mic" title="<?php _e('Enable Microphone', 'bp-better-messages'); ?>"><i class="<?php echo $enable_mic_icon; ?>"></i></span>

                            <span class="bpbm-call-end" title="<?php _e('End call', 'bp-better-messages'); ?>"><i class="fas fa-phone"></i></span>
                        </div>
                    </div>
                </div>

            <?php } else {
                if( $this->video ){ ?>
                    <div class="bp-messages-video-container bp-messages-private-call bp-messages-call-container" style="display: none;" data-thread-id="<?php echo $thread_id ?>" data-my-name="<?php echo BP_Better_Messages_Functions()->get_name( get_current_user_id() ) ?>" data-my-avatar='<?php echo BP_Better_Messages_Functions()->get_avatar( get_current_user_id(), 100, [ 'html' => false ] ); ?>'>
                        <span class="bp-messages-main-video" style="display:none;"></span>
                        <span class="bp-messages-small-video"></span>

                        <div class="bp-messages-main-placeholder">
                            <div class="bp-messages-placeholder-video"></div>
                            <div class="bp-messages-call-animation">
                                <?php echo BP_Better_Messages_Functions()->get_avatar($participants[ 'recipients' ][0], 100); ?>
                            </div>
                            <div class="bp-messages-placeholder-message">
                                <span class="bp-messages-placeholder-incoming-text"><?php _e('Incoming Call', 'bp-better-messages'); ?></span>
                                <span class="bp-messages-placeholder-outgoing-text"><?php _e('Calling...', 'bp-better-messages'); ?></span>
                            </div>
                        </div>
                        <div class="bp-messages-call-controls" style="display: none">
                            <div class="bpbm-call-settings">
                                <div class="bpbm-call-setting bpbm-switch-camera">
                                    <label><?php _e('Camera', 'bp-better-messages'); ?></label>
                                    <div class="bpbm-switch-camera-select-wrap"></div>
                                </div>
                                <div class="bpbm-call-setting bpbm-switch-audio">
                                    <label><?php _e('Speaker', 'bp-better-messages'); ?></label>
                                    <div class="bpbm-switch-audio-select-wrap"></div>
                                </div>
                                <div class="bpbm-call-setting bpbm-switch-mic">
                                    <label><?php _e('Microphone', 'bp-better-messages'); ?></label>
                                    <div class="bpbm-switch-mic-select-wrap"></div>
                                </div>
                            </div>
                            <div class="bpbm-call-out">
                                <span class="bpbm-configure-call" style="display:none" title="<?php _e('Configure', 'bp-better-messages'); ?>"><i class="fas fa-cog"></i></span>
                                <span class="bpbm-switch-camera-video" style="display:none" title="<?php _e('Switch Camera', 'bp-better-messages'); ?>"><i class="fas fa-sync-alt"></i></span>

                                <span class="bpbm-disable-video" title="<?php _e('Disable Video', 'bp-better-messages'); ?>"><i class="<?php echo $disable_video_icon; ?>"></i></span>
                                <span class="bpbm-enable-video" title="<?php _e('Enable Video', 'bp-better-messages'); ?>" style="display: none"><i class="<?php echo $enable_video_icon; ?>"></i></span>

                                <span class="bpbm-disable-mic" title="<?php _e('Disable Microphone', 'bp-better-messages'); ?>"><i class="<?php echo $disable_mic_icon; ?>"></i></span>
                                <span class="bpbm-enable-mic" title="<?php _e('Enable Microphone', 'bp-better-messages'); ?>" style="display: none"><i class="<?php echo $enable_mic_icon; ?>"></i></span>
                                <span class="bpbm-cancel" title="<?php _e('Cancel', 'bp-better-messages'); ?>"><i class="fas fa-phone"></i></span>
                            </div>
                            <div class="bpbm-call-in">
                                <span class="bpbm-answer" data-user-id="<?php echo $participants[ 'recipients' ][0]; ?>" title="<?php _e('Answer', 'bp-better-messages'); ?>"><i class="fas fa-phone"></i></span>

                                <span class="bpbm-configure-call" style="display:none" title="<?php _e('Configure', 'bp-better-messages'); ?>"><i class="fas fa-cog"></i></span>
                                <span class="bpbm-switch-camera-video" style="display:none" title="<?php _e('Switch Camera', 'bp-better-messages'); ?>"><i class="fas fa-sync-alt"></i></span>
                                <span class="bpbm-disable-video" title="<?php _e('Disable Video', 'bp-better-messages'); ?>"><i class="<?php echo $disable_video_icon; ?>"></i></span>
                                <span class="bpbm-enable-video" title="<?php _e('Enable Video', 'bp-better-messages'); ?>" style="display: none"><i class="<?php echo $enable_video_icon; ?>"></i></span>

                                <span class="bpbm-disable-mic" title="<?php _e('Disable Microphone', 'bp-better-messages'); ?>"><i class="<?php echo $disable_mic_icon; ?>"></i></span>
                                <span class="bpbm-enable-mic" title="<?php _e('Enable Microphone', 'bp-better-messages'); ?>" style="display: none"><i class="<?php echo $enable_mic_icon; ?>"></i></span>

                                <span class="bpbm-reject" data-user-id="<?php echo $participants[ 'recipients' ][0]; ?>" title="<?php _e('Reject', 'bp-better-messages'); ?>"><i class="fas fa-phone"></i></span>
                            </div>
                            <div class="bpbm-call-in-progress">
                                <?php /* <span class="bpbm-switch-full-screen" style="display:none" title="<?php _e('Full Screen', 'bp-better-messages'); ?>"><i class="fas fa-expand-alt"></i></span> */ ?>

                                <span class="bpbm-switch-camera-video" style="display:none" title="<?php _e('Switch Camera', 'bp-better-messages'); ?>"><i class="fas fa-sync-alt"></i></span>
                                <span class="bpbm-configure-call" style="display:none" title="<?php _e('Configure', 'bp-better-messages'); ?>"><i class="fas fa-cog"></i></span>

                                <span class="bpbm-disable-video" title="<?php _e('Disable Video', 'bp-better-messages'); ?>"><i class="<?php echo $disable_video_icon; ?>"></i></span>
                                <span class="bpbm-enable-video" title="<?php _e('Enable Video', 'bp-better-messages'); ?>" style="display: none"><i class="<?php echo $enable_video_icon; ?>"></i></span>

                                <span class="bpbm-disable-mic" title="<?php _e('Disable Microphone', 'bp-better-messages'); ?>"><i class="<?php echo $disable_mic_icon; ?>"></i></span>
                                <span class="bpbm-enable-mic" title="<?php _e('Enable Microphone', 'bp-better-messages'); ?>" style="display: none"><i class="<?php echo $enable_mic_icon; ?>"></i></span>

                                <span class="bpbm-call-end" title="<?php _e('End call', 'bp-better-messages'); ?>"><i class="fas fa-phone"></i></span>
                            </div>
                        </div>
                    </div>
                    <?php
                }

                if( $this->audio ){ ?>
                    <div class="bp-messages-audio-container bp-messages-private-call bp-messages-call-container" style="display: none" data-thread-id="<?php echo $thread_id ?>" data-my-name="<?php echo BP_Better_Messages_Functions()->get_name( get_current_user_id() ) ?>" data-my-avatar='<?php echo BP_Better_Messages_Functions()->get_avatar( get_current_user_id(), 100, [ 'html' => false ] ); ?>'>

                        <div class="bp-messages-main-placeholder">
                            <div class="bp-messages-call-animation">
                                <?php echo BP_Better_Messages_Functions()->get_avatar($participants[ 'recipients' ][0], 100); ?>
                            </div>
                            <div class="bp-messages-placeholder-message">
                                <span class="bp-messages-timer"></span>
                                <span class="bp-messages-placeholder-incoming-text"><?php _e('Incoming Call', 'bp-better-messages'); ?></span>
                                <span class="bp-messages-placeholder-outgoing-text"><?php _e('Calling...', 'bp-better-messages'); ?></span>
                            </div>
                        </div>

                        <div class="bp-messages-call-controls" style="display: none">
                            <div class="bpbm-call-settings">
                                <div class="bpbm-call-setting bpbm-switch-audio">
                                    <label><?php _e('Speaker', 'bp-better-messages'); ?></label>
                                    <div class="bpbm-switch-audio-select-wrap"></div>
                                </div>
                                <div class="bpbm-call-setting bpbm-switch-mic">
                                    <label><?php _e('Microphone', 'bp-better-messages'); ?></label>
                                    <div class="bpbm-switch-mic-select-wrap"></div>
                                </div>
                            </div>
                            <div class="bpbm-call-out">
                                <span class="bpbm-configure-call" style="display:none" title="<?php _e('Configure', 'bp-better-messages'); ?>"><i class="fas fa-cog"></i></span>

                                <span class="bpbm-disable-mic" title="<?php _e('Disable Microphone', 'bp-better-messages'); ?>"><i class="<?php echo $disable_mic_icon; ?>"></i></span>
                                <span class="bpbm-enable-mic" title="<?php _e('Enable Microphone', 'bp-better-messages'); ?>" style="display: none"><i class="<?php echo $enable_mic_icon; ?>"></i></span>
                                <span class="bpbm-cancel" title="<?php _e('Cancel', 'bp-better-messages'); ?>"><i class="fas fa-phone"></i></span>
                            </div>
                            <div class="bpbm-call-in">
                                <span class="bpbm-answer" data-user-id="<?php echo $participants[ 'recipients' ][0]; ?>" title="<?php _e('Answer', 'bp-better-messages'); ?>"><i class="fas fa-phone"></i></span>

                                <span class="bpbm-configure-call" style="display:none" title="<?php _e('Configure', 'bp-better-messages'); ?>"><i class="fas fa-cog"></i></span>

                                <span class="bpbm-disable-mic" title="<?php _e('Disable Microphone', 'bp-better-messages'); ?>"><i class="<?php echo $disable_mic_icon; ?>"></i></span>
                                <span class="bpbm-enable-mic" title="<?php _e('Enable Microphone', 'bp-better-messages'); ?>" style="display: none"><i class="<?php echo $enable_mic_icon; ?>"></i></span>

                                <span class="bpbm-reject" data-user-id="<?php echo $participants[ 'recipients' ][0]; ?>" title="<?php _e('Reject', 'bp-better-messages'); ?>"><i class="fas fa-phone"></i></span>
                            </div>
                            <div class="bpbm-call-in-progress">
                                <span class="bpbm-configure-call" style="display:none" title="<?php _e('Configure', 'bp-better-messages'); ?>"><i class="fas fa-cog"></i></span>

                                <span class="bpbm-disable-mic" title="<?php _e('Disable Microphone', 'bp-better-messages'); ?>"><i class="<?php echo $disable_mic_icon; ?>"></i></span>
                                <span class="bpbm-enable-mic" title="<?php _e('Enable Microphone', 'bp-better-messages'); ?>" style="display: none"><i class="<?php echo $enable_mic_icon; ?>"></i></span>

                                <span class="bpbm-call-end" title="<?php _e('End call', 'bp-better-messages'); ?>"><i class="fas fa-phone"></i></span>
                            </div>
                        </div>


                        <div class="bp-messages-audio-element">
                        </div>
                    </div>
                <?php }
            }

            $html = ob_get_clean();
            $class = 'bp-messages-call-wrap';

            if( $isGroupCall ){
                $class .= ' bp-messages-call-wrap-group';
            }
            echo '<div class="' . $class . '"><span class="bpbm-switch-chat" title="' . __('Toggle Chat', 'bp-better-messages') . '"><i class="fas fa-caret-left"></i></span>' . $html . '</div>';
        }


        public function thread_group_call_admin(){
            if( ! wp_verify_nonce( $_POST[ 'nonce' ], 'bpbm_edit_nonce' ) ){
                exit;
            }

            $user_id = get_current_user_id();
            $thread_id = intval( $_POST['thread_id'] );
            $token = sanitize_text_field( $_POST['token'] );

            $action = sanitize_text_field( $_POST['act'] );

            $video_cloud_server = apply_filters( 'bp_better_messages_video_cloud', 'https://video-cloud.bpbettermessages.com/' );
            $can_moderate = BP_Better_Messages()->functions->is_thread_super_moderator( $user_id, $thread_id );

            if( ! $can_moderate ) {
                wp_send_json( false );
            }

            $headers =  [
                'Content-Type'   => 'application/json',
                'Authorization'  => 'Bearer ' . $token,
            ];

            if( $action === 'remove_participant' ) {
                $user_to_remove = intval( $_POST['user_id'] );

                $payload = json_encode([
                    'room' => BP_Better_Messages()->premium->site_id . '_' . $thread_id,
                    'identity' => 'user_' . $user_to_remove
                ]);

                $request = wp_remote_post($video_cloud_server . 'twirp/livekit.RoomService/RemoveParticipant', array(
                    'body' => $payload,
                    'headers' => $headers
                ));

                if (!is_wp_error($request)) {
                    wp_send_json(json_decode($request['body']));
                }
            }

            wp_send_json( false );
        }

        public function get_thread_group_call_access_key(){
            if( ! wp_verify_nonce( $_POST[ 'nonce' ], 'bpbm_edit_nonce' ) ){
                wp_send_json(__( 'Security error', 'bp-better-messages' ));
                exit;
            }

            $user_id = get_current_user_id();
            $user = get_userdata( $user_id );
            $thread_id = intval( $_POST['thread_id'] );
            $video_management_server = apply_filters( 'bp_better_messages_video_management', 'https://realtime-cloud.bpbettermessages.com/' );

            $can_join = false;
            $can_moderate = BP_Better_Messages()->functions->is_thread_super_moderator( $user_id, $thread_id );
            if( $can_moderate ){
                $can_join = true;
            }

            if( ! $can_join ){
                $can_join = BP_Better_Messages()->functions->is_thread_participant( $user_id, $thread_id );
            }

            if( ! $can_join ){
                wp_send_json( false );
            }

            $request = [
                'site_id'    => BP_Better_Messages()->premium->site_id,
                'secret_key' => sha1( BP_Better_Messages()->premium->site_id . BP_Better_Messages()->premium->secret_key ),
                'user_id'    => $user_id,
                'thread_id'  => $thread_id,
                'meta'       => json_encode([
                    'name'          => ( ! empty( $user->display_name ) ) ? $user->display_name : $user->user_login,
                    'avatar'        => BP_Better_Messages_Functions()->get_avatar($user->ID, 200, [ 'html' => false ] )
                ]),
                'is_admin' => ($can_moderate) ? '1' : '0',
                'can_publish' => '1',
                'can_publish_data' => '1',
                'can_subscribe' => '1',
                'is_hidden' => '0',
            ];

            $request = wp_remote_post( $video_management_server . 'getCallAuthKey', array(
                'body' => $request,
                'blocking' => true
            ) );

            $token = $request['body'];

            wp_send_json( $token );
        }
    }

endif;


function BP_Better_Messages_Calls()
{
    return BP_Better_Messages_Calls::instance();
}
